package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.resource.dto.resource.MenuView;
import cn.gtmap.gtcc.domain.resource.metadata.Menu;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 * @author zgl
 * @date 2018-04-27
 */
@FeignClient("resource-core")
@RequestMapping("/menu")
public interface MenuClient {

    @RequestMapping("saveMenu")
    public Menu saveMenu(Menu menu);

    @RequestMapping("saveMenuParams")
    public Menu saveMenuParams(@RequestParam(name = "parentId", required = false) String parentId,
                               @RequestParam(name = "id", required = false) String id,
                               @RequestParam(name = "name", required = false) String name,
                               @RequestParam(name = "type", required = false) String type,
                               @RequestParam(name = "url", required = false) String url,
                               @RequestParam(name = "remark", required = false) String remark,
                               @RequestParam(name = "isAdd", required = false) boolean isAdd,
                               @RequestParam(name = "icon", required = false) String icon,
                               @RequestParam(name = "css", required = false) String css);

    @RequestMapping("/deleteMenu/{id}")
    public void deleteMenu(@PathVariable(name = "id") String id);

    @RequestMapping("/query/getAllMenus")
    public List<MenuView> getAllMenus();

    @RequestMapping("/query/findMenuById")
    MenuView findMenuById(@RequestParam(name = "id", required = false) String id);

    @RequestMapping("/query/findMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc")
    MenuView findMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc(@RequestParam(name = "id", required = false) String id, @RequestParam(name = "type", required = false) String type);

    @RequestMapping("/updateMenu")
    public Menu updateMenu(@RequestParam(name = "nodeArr[]") String[] nodeArr, @RequestParam(name = "type") String type);

    @RequestMapping("/associate/associateMenuAndRoleList")
    public String associateMenuAndRoles(@RequestParam(name = "menuId") String menuId,
                                      @RequestParam(name = "roleIds[]") String[] roles,
                                      @RequestParam(name = "replaceAll", required = false) boolean replace);

    @RequestMapping("/remove/removeMenuAndRoleList")
    public String removeMenuAndRole(@RequestParam(name = "menuId") String menuId,
                                     @RequestParam(name = "roleId") String roleId);

    @RequestMapping("/query/queryMenuRoleRefsByMenuId")
    List<String> queryMenuRoleRefsByMenuId(@RequestParam(name = "menuId", required = false) String menuId);

    @RequestMapping("/query/queryMenuRoleRefsByRoleId")
    List<String> queryMenuRoleRefsByRoleId(@RequestParam(name = "roleId", required = false) String roleId);

}
