package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Keyword;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by zgl on 2017-12-02.
 */
@FeignClient("resource-core")
@RequestMapping("/keyword")
public interface KeywordClient {

    /**
     * 查询关键字
     * @param strContent
     * @return
     */
    @GetMapping("/findKeywordByStr")
    public List<Keyword> findKeywordByStr(@RequestParam(name = "strContent", required = false) String strContent);

    @PostMapping("/save")
    public String saveKeyWord(@RequestBody Keyword keyword);

    @RequestMapping("/delete/{id}")
    public Boolean deleteKeyword(@PathVariable(name = "id") String id);
}
