package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Dict;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *
 * @author zgl
 * @date 2018-03-16
 */
@FeignClient("resource-core")
@RequestMapping("/dict")
public interface DictClient {

    /**
     * 保存dict
     * @param dict
     * @return
     */
    @PostMapping("/saveDict")
    public Dict saveDict(@RequestBody Dict dict);

    /**
     * 根据type查询catalogIds
     *
     * @param type
     * @return
     */
    @RequestMapping("/findDictByType/type/{type}")
    Dict findDictByType(@PathVariable(name = "type") String type);

    /**
     * 根据type查询dict
     *
     * @param key
     * @return
     */
    @RequestMapping("/findValueByKey/key/{key}")
    Dict findValueByKey(@PathVariable(name = "key") String key);

    /**
     * 根据parentId查询dictList
     *
     * @param parentId
     * @return
     */
    @RequestMapping("/findDefaultDicts/parentId/{parentId}")
    List<Dict> findDefaultDicts(@PathVariable(name = "parentId") String parentId);

    /**
     * 根据parentId查询dictList
     *
     * @return
     */
    @RequestMapping("/findRootDicts")
    List<Dict> findRootDicts();

    /**
     * 保存catalog
     */
    @RequestMapping("/saveDictParams")
    public Dict saveDictParams(@RequestParam(name = "dictParentId", required = false) String dictParentId,
                                     @RequestParam(name = "dictId", required = false) String dictId,
                                     @RequestParam(name = "dictKey", required = false) String dictKey,
                                     @RequestParam(name = "dictValue", required = false) String dictValue,
                                     @RequestParam(name = "dictTitle", required = false) String dictTitle,
                                     @RequestParam(name = "isAdd", required = false) boolean isAdd,
                                     @RequestParam(name = "parentDictKey", required = false) String parentDictKey);

    @RequestMapping("/deleteDict/{id}")
    public void deleteDict(@PathVariable(name = "id") String id);


    @RequestMapping("/updateDict")
    public Dict updateDict(@RequestParam(name = "nodeArr[]") String[] nodeArr,@RequestParam(name = "type") String type);

    /**
     * 根据dicId查询dict
     *
     * @param dicId
     * @return
     */
    @RequestMapping("/findDictByDicId/dicId/{dicId}")
    Dict findDictByDicId(@PathVariable(name = "dicId") String dicId);

}
