package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.resource.metadata.source.DataBase;
import cn.gtmap.gtcc.domain.resource.metadata.source.TableInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by fanyoudu on 2017/11/28.
 */
@FeignClient("resource-dbh")
@RequestMapping("/rest/dbh")
public interface DBHClient {

    /**
     * 根据连接返回表列表
     *
     * @return
     */
    @PostMapping("/query/table")
    public List<TableInfo> getTablesByDB(@RequestBody DataBase dataBase);

    /**
     * 保存连接
     *
     * @return
     */
    @PostMapping("/save/dataBase")
    public DataBase tableCon(@RequestBody DataBase dataBase);

    /**
     * 根据连接返回表列表
     *
     * @return
     */
    @RequestMapping("/get/page")
    public Page<Map> getPageList(@RequestParam(name = "id") String id, @RequestParam(name = "paramString") String paramString, Pageable pageable);

    /**
     * 根据连接返回表列表
     *
     * @return
     */
    @RequestMapping("/get/list")
    public List<Map> getMapList(@RequestParam(name = "id") String id, @RequestParam(name = "paramString") String paramString);
}
