package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.region.Region;
import cn.gtmap.gtcc.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtcc.domain.resource.metadata.Catalog;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * CatalogClient
 *
 * @author monarchCheng
 * @create 2017-11-14 14:40
 **/
@FeignClient("resource-core")
@RequestMapping("/catalog")
public interface CatalogClient {

    /**
     * 查询根目录
     *
     * @param type
     * @return
     */
    @RequestMapping("/query/root/{type}")
    List<CatalogView> findRootCatalog(@PathVariable(name = "type") String type);

    /**
     * 默认根目录
     *
     * @return
     */
    @RequestMapping("/default/root")
    List<CatalogView> findRootCatalog();

    /**
     * find RootCatalog Groups
     *
     * @return
     */
    @GetMapping("/root/groups")
    Map findRootCatalogGroups();

    /**
     * find RootCatalog Groups
     *
     * @return
     */
    @GetMapping("/root/getDataDownloadCatalogGroups")
    Map getDataDownloadCatalogGroups();


    /**
     * 查询目录的子目录
     *
     * @param id
     * @return
     */
    @RequestMapping("/query/{id}/children")
    List<CatalogView> findChildCatalog(@PathVariable(name = "id") String id);


    /**
     * 查询所有目录
     *
     * @param parentId
     * @return
     */
    @GetMapping("/query/children/{parentId}")
    List<CatalogView> findByParentId(@PathVariable(name = "parentId") String parentId);

    /**
     * 根据类型查询目录
     *
     * @param type
     * @return
     */
    @RequestMapping("/query/type/{type}")
    List<Catalog> findCatalogByType(@PathVariable(name = "type") String type);


    /**
     * 根据id查询目录
     *
     * @param id
     * @return
     */
    @RequestMapping("/query/id/{id}")
    Catalog findCatalogById(@PathVariable(name = "id") String id);


    /**
     * 查询所有目录
     *
     * @return
     */
    @RequestMapping("/query/findAllCatalogByType/{type}")
    List<CatalogView> findAllCatalogByType(@PathVariable(name = "type") String type);

    @GetMapping("/query/findParentByChild/{id}")
    public List findParentByChild(@PathVariable(name = "id") String id);

    /**
     * 查询子行政区
     *
     * @param id
     * @return
     */
    @GetMapping("/region/child/{id}")
    Iterable<Region> findRegionChild(@PathVariable(name = "id") String id);

    /**
     * 保存catalog
     */
    @PostMapping("/saveCatalog")
    public Catalog saveCatalog(@RequestBody Catalog catalog);

    /**
     * 保存catalog
     */
    @RequestMapping("/saveCatalogParams")
    public Catalog saveCatalogParams(@RequestParam(name = "parentId", required = false) String parentId,
                                     @RequestParam(name = "parentType", required = false) String parentType,
                                     @RequestParam(name = "catalogId", required = false) String catalogId,
                                     @RequestParam(name = "catalogType", required = false) String catalogType,
                                     @RequestParam(name = "catalogTitle", required = false) String catalogTitle,
                                     @RequestParam(name = "catalogRemark", required = false) String catalogRemark,
                                     @RequestParam(name = "isAdd", required = false) boolean isAdd,
                                     @RequestParam(name = "dicId", required = false) String dicId);

    /**
     * 删除catalog
     *
     * @param id
     */
    @RequestMapping("/deleteCatalog/{id}")
    public void deleteCatalog(@PathVariable(name = "id") String id);

    /**
     * 删除catalog
     *
     * @param type
     */
    @RequestMapping("/deleteCatalogByType/{type}")
    public void deleteCatalogByType(@PathVariable(name = "type") String type);

    /**
     * 删除ref
     *
     * @param id
     */
    @RequestMapping("/deleteRef/{id}")
    public void deleteRef(@PathVariable(name = "id") String id);

    /**
     * 默认根目录
     *
     * @return
     */
    @GetMapping("/findAllRootCatalog/{parentId}")
    List<Catalog> findAllRootCatalog(@PathVariable(name = "parentId") String parentId);

    /**
     *
     */
    @GetMapping("/findCatRefList/{id}")
    List<String> findCatRefList(@PathVariable(name = "id") String id);

    /**
     * saveResToCat
     */
    @RequestMapping("/associate/catalogAndResource")
    public Catalog associateCatalogAndResources(@RequestParam(name = "catalogId") String catalogId,
                                                @RequestParam(name = "resources[]") String[] resourceIds,
                                                @RequestParam(name = "replaceAll", required = false) boolean replace);
    /**
     * saveResToCat
     */
    @RequestMapping("/updateCatalog")
    public Catalog updateCatalog(@RequestParam(name = "nodeArr[]") String[] nodeArr,@RequestParam(name = "type") String type);

    /**
     * removeResToCat
     */
    @RequestMapping("/remove/resource/ref")
    public Catalog removeCatalogAndResources(@RequestParam(name = "catalogId") String catalogId,
                                             @RequestParam(name = "resources[]") String[] resourceIds);


    /**
     * 统计分页根据 type = RESC来统计当前四大类下有多少资源数量
     *
     * @return key类别 value 数量
     */
    @GetMapping("/sourcesCount")
    Map<String, Integer> getSourcesCountByType();

    /**
     * 默认根目录
     *
     * @return
     */
    @GetMapping("/findCatalogIdsByIds/{catalogIds}")
    List<Catalog> findCatalogIdsByIds(@PathVariable(name = "catalogIds") String catalogIds);
}
