package cn.gtmap.gtcc.clients.resource;

import cn.gtmap.gtcc.domain.resource.metadata.Announcement;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * Created by Administrator on 2018/3/27.
 */
@FeignClient("resource-core")
@RequestMapping("/announcement")
public interface AnnouncementClient {
    @GetMapping("/getAnnouncementByPage")
    Page<Announcement> getAnnouncementByPage(@RequestParam(name = "title") String title, Pageable pageable);

    @GetMapping("/getAnnouncementByPublisher")
    Page<Announcement> getAnnouncementByPublisher(@RequestParam(name = "title") String title, @RequestParam(name = "username") String username, Pageable pageable);

    @PostMapping("/saveAnnouncement")
    Boolean saveAnnouncement(@RequestBody Announcement announcement);

    @RequestMapping("/deleteAnnouncement")
    public Boolean deleteAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/findAnnouncement")
    public Announcement findAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/updateAnnouncement")
    public boolean updateAnnouncement(@RequestBody Announcement announcement);
}
