package cn.gtmap.gtcc.clients.region;

import cn.gtmap.gtcc.domain.region.Region;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .RegionClient
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/16 17:04
 */
@FeignClient("region-app")
@RequestMapping("/rest/region")
public interface RegionClient {

    /**
     * get root regions
     *
     * @return
     */
    @GetMapping("/root")
    Iterable<Region> getRootRegion();

    /**
     * get region
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    Region get(@PathVariable(name = "id") String id);

    /**
     * get region parent
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/parent")
    Region getParent(@PathVariable(name = "id") String id);

    /**
     * get region children
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}/children")
    Iterable<Region> getChildren(@PathVariable(name = "id") String id);

    /**
     * search regions
     *
     * @param type
     * @param value
     * @return
     */
    @PostMapping(value = "/search")
    Page<Region> searchRegions(@RequestParam(name = "type") String type, @RequestParam(name = "value") String value, Pageable pageable);

    /**
     * level regions
     *
     * @param level
     * @param parentId
     * @return
     */
    @PostMapping(value = "/level")
    Page<Region> levelRegions(@RequestParam(name = "level") int level, @RequestParam(name = "parentId", required = false) String parentId, Pageable pageable);

    /**
     * disable region
     *
     * @param id
     * @return
     */
    @PostMapping("/{id}/disable")
    boolean disableChildren(@PathVariable(name = "id") String id);

    @GetMapping("/{id}/getAllRegions")
    Region getAllRegions(@PathVariable(name = "id") String id);

    /**
     * get region
     *
     * @param code
     * @return
     */
    @RequestMapping("/{code}/findRegionByCode")
    Region findRegionByCode(@PathVariable(name = "code") String code);

    @PutMapping("/add/{parentId}")
    Region addRegion(@PathVariable(name = "parentId") String parentId, @RequestBody Region region);

    @GetMapping("/{id}/deleteRegion")
    boolean deleteRegion(@PathVariable(name = "id") String id);

    @PutMapping("/{parentId}/updateRegion")
    boolean updateRegion(@PathVariable(name = "parentId") String parentId, @RequestBody Region region);

    @GetMapping("/{parentId}/getChildrenRegions")
    public List<Region> getChildrenRegions(@PathVariable(name = "parentId") String parentId);
}
