package cn.gtmap.gtcc.clients.log;

import cn.gtmap.gtcc.domain.log.ResponseMessage;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by Fjj on 2017/12/7.
 */
@FeignClient("log-app")
@RequestMapping("/log/server")
public interface LogClient {

    /**
     *
     * @param serverName 需要查询的url通配符
     * @param startTime 起始时间
     * @param endTime 结束时间
     * @return 返回消息
     */
    @GetMapping({"/hot"})
    ResponseMessage getHotResource(@RequestParam(name = "servername") String serverName, @RequestParam(name = "starttime") Long startTime, @RequestParam(name = "endtime") Long endTime);


    /**
     *
     * @param serverName 需要查询的url通配符
     * @param startTime 起始时间
     * @param endTime 结束时间
     * @param interval 时间间隔
     * @return 返回消息
     */
    @GetMapping({"/days"})
    ResponseMessage getDaysInfoBySearchName(@RequestParam(name = "servername") String serverName, @RequestParam(name = "startTime")long startTime, @RequestParam(name = "endTime") long endTime,@RequestParam(name = "interval") String interval);

    /**
     *
     * @param serverName 需要查询的url通配符
     * @param startTime 起始时间
     * @param endTime 结束时间
     * @return 返回消息
     */
    @GetMapping("/total")
    ResponseMessage getAllResource(@RequestParam(name = "servername") String serverName, @RequestParam(name = "starttime") long startTime, @RequestParam(name = "endtime") long endTime);
}
