package cn.gtmap.gtcc.clients.gis.sde;

import cn.gtmap.gtcc.domain.gis.data.search.ResultBean;
import cn.gtmap.gtcc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.domain.gis.sde.LayerRegionC;
import cn.gtmap.gtcc.domain.gis.sde.QueryParams;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author panrong
 */
@FeignClient("gis-sde")
@RequestMapping("/rest/sde")
public interface SdeClient {

    /**
     * 按属性查询图层统计信息
     *
     * @param layerName
     * @param where
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/attStates")
    Map<String, Object> attStates(@RequestParam("layerName") String layerName,
                                  @RequestParam(value = "where", required = false) String where,
                                  @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 按属性查询图层
     *
     * @param layerName
     * @param where
     * @param columns
     * @param returnGeometry
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/attribute")
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestParam(value = "where", required = false) String where,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "returnGeometry", defaultValue = "true") boolean returnGeometry,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 按空间查询图层
     *
     * @param layerName
     * @param wkt
     * @param columns
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/query/space", method = RequestMethod.POST)
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestBody String wkt,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 分析空间查询参数过大使用
     *
     * @param params
     * @return
     */
    @RequestMapping(value = "/query/space2", method = RequestMethod.POST)
    FeatureCollection query2(@RequestBody QueryParams params);

    /**
     * 多图层按属性查询下载
     *
     * @param taskIds
     * @param layerNames
     * @param wheres
     * @param columns
     * @param dataSource
     * @return
     * @Param taskIds
     */
    @RequestMapping(value = "/query/attribute/download", method = RequestMethod.POST)
    ResultBean queryDownloadByAttribute(@RequestParam("taskIds") String taskIds,
                                        @RequestParam("layerNames") String layerNames,
                                        @RequestParam(value = "fileNames", required = false, defaultValue = "") String fileNames,
                                        @RequestParam(value = "wheres", required = false, defaultValue = "") String wheres,
                                        @RequestParam(value = "columns", required = false, defaultValue = "") String columns,
                                        @RequestParam(value = "dataSource", defaultValue = "") String dataSource);


    /**
     * 多图层按空间属性联合查询下载
     *
     * @param params
     * @return
     */
    @RequestMapping(value = "/query/space/download", method = RequestMethod.POST)
    ResultBean queryDownloadBySpaceAttribute(@RequestBody Map params);

    /**
     * 多图层按对应属性条件查询下载
     *
     * @param taskIds
     */
    @GetMapping("/query/task/result")
    List<ResultBean> getQueryResult(@RequestParam("taskIds") String taskIds);


    /**
     * 获取图层空间参考
     *
     * @param layerName
     * @param dataSource
     * @return
     */
    @RequestMapping("/CoordinateReferenceSystem")
    String getLayerCRS(@RequestParam("layerName") String layerName,
                       @RequestParam("dataSource") String dataSource);

    @RequestMapping("/getLayerRegion")
    LayerRegionC getLayerRegion(@RequestParam("layerName") String layerName);

    @RequestMapping("/getLayerColumns")
    String[] getLayerColumns(@RequestParam("layerName") String layerName,
                             @RequestParam("dataSource") String dataSource);

    /**
     * 空间属性联合查询图层
     *
     * @param layerName
     * @param wkt
     * @param where
     * @param columns
     * @param dataSource
     * @return
     */
    @RequestMapping("/query/spaceAttribute")
    FeatureCollection query(@RequestParam("layerName") String layerName,
                            @RequestParam(value = "wkt") String wkt,
                            @RequestParam(value = "where") String where,
                            @RequestParam(value = "columns", required = false) String[] columns,
                            @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * get crs by reset regionCode sets
     *
     * @param regionCode
     * @return
     */
    @RequestMapping("/getCRSByRegionCode")
    String getCRSByRegionCode(@RequestParam("regionCode") String regionCode);

    /**
     * 此接口用于数据下载中的图层校验
     * 此接口的使用前提是：不存在不同数据源但是用户相同的情况
     *
     * @param layerName user.table
     * @return
     */
    @RequestMapping("/checkLayer")
    boolean checkLayer(@RequestParam("layerName") String layerName);

    /**
     * 获取数据源的图层列表
     *
     * @param dataSource
     * @return
     */
    @RequestMapping("/getLayers")
    List<String> getLayers(@RequestParam("dataSource") String dataSource);

    /**
     * 获取数据源的图层列表
     *
     * @param dataSource
     * @return
     */
    @RequestMapping("/getTables")
    List<String> getTables(@RequestParam("dataSource") String dataSource, @RequestParam(value = "permissions", required = false, defaultValue = "2") int permissions);

    /**
     * 监测图层是否存在
     *
     * @param layerName
     * @param dbSource
     * @return
     */
    @RequestMapping("/spatialDao/detectLayer")
    boolean detectLayer(@RequestParam("layerName") String layerName,
                        @RequestParam("dbSource") String dbSource);

    /**
     * 根据坐标中心的X坐标获取坐标系信息
     *
     * @param x
     * @return
     */
    @RequestMapping("/getCrsByCoordX")
    Map getCrsByCoordX(@RequestParam("x") double x);

    /**
     * default crs
     *
     * @return
     */
    @RequestMapping("/getDefaultCrs")
    String getDefaultCrs();

    /**
     * 获取资源列表
     *
     * @return
     */
    @RequestMapping("/getDataSourceList")
    List<String> getDataSourceList();

    /**
     * 获取sde图层所选范围内是否完全包含输入geometry
     * 为省厅分析前检查分析图形是否在行政区范围内
     *
     * @param params
     * @return
     */
    @RequestMapping(value = "/inBound", method = RequestMethod.POST)
    Map inBound(@RequestBody Map params);

    /**
     * 插入要素
     *
     * @param layerName
     * @param geometry   GeoJSON 格式要素
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/insert")
    Map insert(@RequestParam("layerName") String layerName,
               @RequestParam(value = "geometry", required = false) String geometry,
               @RequestParam(value = "check", required = false, defaultValue = "false") Boolean check,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 更新要素
     *
     * @param layerName
     * @param primaryKey
     * @param geometry   GeoJSON 格式要素
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/update")
    Map update(@RequestParam("layerName") String layerName,
               @RequestParam(value = "primaryKey") String primaryKey,
               @RequestParam(value = "geometry") String geometry,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * 删除要素
     *
     * @param layerName
     * @param primaryKey 要素主键
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/delete")
    Map delete(@RequestParam("layerName") String layerName,
               @RequestParam(value = "primaryKey") String primaryKey,
               @RequestParam(value = "dataSource", defaultValue = "") String dataSource);

    /**
     * get crs by point
     * @param wkt
     * @return
     */
    @PostMapping("/getCrsByGeoPoint")
    Map getCrsByGeoPoint(@RequestBody String wkt);
}
