package cn.gtmap.gtcc.clients.gis.data.search;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Map;

/**
 * @author Fjj
 * @date 2018/6/6
 */
@FeignClient("gis-search")
@RequestMapping("/es/{name}/rest")
public interface EsRestClient {

    /**
     * 校验geometry数据是否在regionCode指定的行政区划范围内
     *
     * @param params
     * @return
     */
    @PostMapping({"/checkGeometry"})
    boolean checkGeometry(@RequestBody Map params, @PathVariable("name") String name);

}
