package cn.gtmap.gtcc.clients.gis.cluster;

import cn.gtmap.gtcc.domain.gis.cluster.GisCluster;
import cn.gtmap.gtcc.domain.gis.data.search.ResultBean;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by Fjj on 2017/12/7.
 */
@FeignClient("gis-cluster")
@RequestMapping("/rest/cluster")
public interface GisClusterClient {

    /**
     * 查询所有集群信息
     *
     * @return
     */
    @GetMapping({"/queryall"})
    List<GisCluster> queryAll();

    /**
     * 查询指定id的集群
     *
     * @param id
     * @return
     */
    @GetMapping({"/querybyid"})
    GisCluster queryById(@RequestParam(name = "id") String id);

    /**
     * 添加新集群
     *
     * @param cluster
     * @return
     */
    @PostMapping({"/add"})
    ResultBean add(@RequestBody GisCluster cluster);

    /**
     * 更新集群信息
     *
     * @param cluster
     * @return
     */
    @PostMapping({"/update"})
    ResultBean update(@RequestBody GisCluster cluster);

    /**
     * @param id
     * @return
     */
    @GetMapping({"/delete"})
    ResultBean delete(@RequestParam(name = "id") String id);

    /**
     * 查询指定名称的集群
     *
     * @param name
     * @return
     */
    @GetMapping({"/querybyname"})
    GisCluster queryByName(@RequestParam(name = "name") String name);
}
