package cn.gtmap.gtcc.clients.gis.analysis;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * .GISMiscClient
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/5/7 (c) Copyright gtmap Corp.
 */
@FeignClient("gis-data-analysis")
@RequestMapping("/gis/misc")
public interface GISMiscClient {

    /***
     * 拓扑检查
     * @param geometry
     * @return
     */
    @PostMapping(value = "/geoCheck")
    String geoTopoCheck(@RequestBody String geometry);

    /***
     * 获取图形面积
     * @param geometry
     * @param crs
     * @return
     */
    @PostMapping(value = "/geoArea")
    double geoArea(@RequestBody String geometry,
                   @RequestParam(value = "crs", defaultValue = "4610") String crs);

    /**
     * 根据参数进行检查，并返回图形拓扑、面积、是否在所属范围内信息
     *
     * @param params geometry , topo check , bound(regionCode) check , get Area
     * @return result(topo Area inbound)
     */
    @PostMapping("/checkGeoJson")
    Map checkGeoJson(@RequestBody Map params);

    /**
     * 导入上传文件
     *
     * @param {"fileBytes":"","fileName":""}
     */
    @PostMapping(value = "/parseGeoFile2")
    String parseGeoFile(@RequestBody Map map);

}
