package cn.gtmap.gtcc.clients.gis.analysis;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * gis 分析 client
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/5/4 (c) Copyright gtmap Corp.
 */
@FeignClient("gis-data-analysis")
@RequestMapping("/gis/analysis")
public interface GISAnalysisClient {

    /**
     * 规划审查分析
     *
     * @param layerType
     * @param year
     * @param geometry
     * @param outFields
     * @param dataSource
     * @param unit
     * @return
     */
    @RequestMapping(value = "/tdghsc", method = RequestMethod.POST)
    Map tdghscAnalysis(@RequestParam(value = "layerType", defaultValue = "") String layerType,
                       @RequestParam(value = "year", defaultValue = "2020") String year,
                       @RequestParam(value = "geometry") String geometry,
                       @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                       @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource,
                       @RequestParam(value = "unit", defaultValue = "SQUARE", required = false) String unit);

    /***
     * 土地利用现状分析
     * @param dltb
     * @param xzdw
     * @param regionCode
     * @param year
     * @param geometry
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/tdlyxz", method = RequestMethod.POST)
    Map tdlyxzAnalysis(@RequestParam(value = "dltb", required = false) String dltb,
                       @RequestParam(value = "xzdw", required = false) String xzdw,
                       @RequestParam(value = "regionCode", required = false) String regionCode,
                       @RequestParam(value = "year", required = false) String year,
                       @RequestParam(value = "geometry", required = true) String geometry,
                       @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /***
     * 一般相交分析
     * @param layerName
     * @param geometry
     * @param outFields
     * @param titleField
     * @param fieldAlias
     * @param dataSource
     * @return
     */
    @RequestMapping(value = "/common", method = RequestMethod.POST)
    Map analysis(@RequestParam(value = "layerName") String layerName,
                 @RequestParam(value = "geometry") String geometry,
                 @RequestParam(value = "outFields") String outFields,
                 @RequestParam(value = "titleField") String titleField,
                 @RequestParam(value = "fieldAlias") String fieldAlias,
                 @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);

    /**
     * 地理相交
     *
     * @param layerName
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    @PostMapping(value = "/intersect")
    Map intersect(@RequestParam("layerName") String layerName,
                  @RequestParam("geometry") String geometry,
                  @RequestParam(value = "outFields", defaultValue = "*") String outFields,
                  @RequestParam(value = "dataSource", defaultValue = "", required = false) String dataSource);


    /***
     * 发布 shapefile 的 zip 包到 arcgis ga
     * @param params {file:  base64 编码后的 string,sr}
     * @return
     */
    @RequestMapping(value = "/publishToGa", method = RequestMethod.POST)
    String publishGaLayer(@RequestBody String params);

    /**
     * 土地利用现状分析
     *
     * @param map {"dltb":"","xzdw":"","regionCode":"","year":"","geometry":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/tdlyxz2")
    Map tdlyxzAnalysis(@RequestBody Map map);

    /**
     * 规划审查分析
     *
     * @param map {"layerType":"","year":"","geometry":"","outFields":"","dataSource":"","unit":""}
     * @return
     */
    @RequestMapping(value = "/tdghsc2", method = RequestMethod.POST)
    Map tdghscAnalysis(@RequestBody Map map);

    /**
     * 地理相交
     *
     * @param map {"layerName":"","geometry":"","outFields":"","dataSource":""}
     * @return
     */
    @PostMapping(value = "/intersect2")
    Map intersect(@RequestBody Map map);
}
