package cn.gtmap.gtcc.clients.display;

import cn.gtmap.gtcc.domain.resource.metadata.display.DisplayCenter;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * display client
 *
 * @author yhj
 * @create 2017-11-14 10:47
 **/
@FeignClient("resource-core")
@RequestMapping("/display")
public interface DisplayCenterClient {

    /**
     * 根据业务查询
     * @param business
     * @return
     */
    @RequestMapping("/query/business/{business}")
    public List<DisplayCenter> findByBusiness(@PathVariable("business") String business);

    /**
     * 根据业务分页查询
     * @param business
     * @param pageable
     * @return
     */
    @RequestMapping("/query/business")
    public Page<DisplayCenter> findByBusiness(@RequestParam("business") String business, Pageable pageable);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    @RequestMapping("/query/id/{id}")
    public DisplayCenter findById(@PathVariable("id") String id);

    /**
     * 保存列表
     * @param displayCenterList
     * @return
     */
    @PostMapping("/save")
    public List<DisplayCenter> save(@RequestBody List<DisplayCenter> displayCenterList);

    /**
     * 根据id删除
     * @param id
     */
    @RequestMapping("/delete/{id}")
    public void delete(@PathVariable("id") String id);

}
