package cn.gtmap.gtcc.clients.dev;

import cn.gtmap.gtcc.domain.dev.Article;
import cn.gtmap.gtcc.domain.dev.Comment;
import cn.gtmap.gtcc.domain.dev.Index;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/12/5
 * @description dev 使用代理接口
 */
@FeignClient("dev")
@RequestMapping("/dev/data/")
public interface DevDataClient {

    /**
     * 添加文章信息
     * @param article
     * @return
     */
    @PostMapping("add/article")
    public String addArticle(@RequestBody Article article);

    /**
     * 查找文章信息
     * @param id
     * @return
     */
    @PostMapping("search/article")
    public Article searchArticle(@RequestParam("id") String id);

    /**
     * 根据目录id查找文章
     * @param id
     * @param pageable
     * @return
     */
    @PostMapping("search/category")
    public Page<Article> searchArticleByCategoryId(@RequestParam("id") String id, Pageable pageable);

    /**
     * 添加评论信息
     * @param comment
     * @return
     */
    @PostMapping("add/comment")
    public String addComment(@RequestBody Comment comment);

    /**
     * 根据id查找评论
     * @param id
     * @return
     */
    @PostMapping("search/comment/id")
    public Comment searchComment(@RequestParam("id") String id);

    /**
     * 根据文章id查找评论信息
     * @param articleId
     * @param pageable
     * @return
     */
    @PostMapping("search/comment/articleid")
    public Page<Comment> searchCommentByArticleId(@RequestParam("articleId") String articleId, Pageable pageable);

    /**
     * 根据评论id获取评论
     * @param commentId
     * @param pageable
     * @return
     */
    @PostMapping("search/comment/commentid")
    public Page<Comment> searchCommentByCommentId(@RequestParam("commentId") String commentId, Pageable pageable);

    /**
     * 按照id删除评论
     * @param commentId
     */
    @PostMapping("delete/comment")
    public void deleteCommentById(@RequestParam("commentId") String commentId);

    /**
     * 按照文章id删除文章
     * @param articleId
     */
    @PostMapping("delete/article")
    public void deleteArticleById(@RequestParam("articleId") String articleId);


    /**
     *
     * @param article
     */
    @PostMapping("update/article")
    public void updateArticleById(@RequestBody Article article);

    /**
     *
     * @param comment
     */
    @PostMapping("update/comment")
    public void updateComment(@RequestBody Comment comment);

    /**
     *
     * @param categoryid
     * @return
     */
    @PostMapping("search/index/article")
    public List<Article> getArticleByCatgoryId(@RequestParam("categoryid") String categoryid);

    /**
     * 文档检索
     * @param query
     * @param pageable
     * @return
     */
    @PostMapping("search/article/fuzz")
    public Page<Article> getArticleFuzz(@RequestParam("query") String query, Pageable pageable);

    /**
     * 获取父目录编码
     * @return
     */
    @PostMapping("get/index")
    public List<Index> getParentIndex();

    /**
     * 添加目录
     * @param index
     * @return
     */
    @PostMapping("add/index")
    public String addIndex(@RequestBody Index index);

    /**
     * 更新目录
     * @param index
     * @return
     */
    @PostMapping("update/index")
    public boolean updateIndex(@RequestBody Index index);

    /**
     * 获取某个目录下的子目录
     * @param parentId
     * @return
     */
    @PostMapping("get/parentid")
    public List<Index> getParentIdIndex(@RequestParam("parentId") String parentId);

    /**
     * 删除目录
     * @param indexId
     * @return
     */
    @PostMapping("delete/index")
    public boolean deleteIndex(@RequestParam("indexId") String indexId);

    /**
     * 获取目录
     * @param indexId
     * @return
     */
    @PostMapping("get/indexId")
    public Index getIndxById(@RequestParam("indexId") String indexId);

}
