
package cn.gtmap.gtcc.clients;

import cn.gtmap.gtcc.ex.DiscoverClientNotFoundException;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

import java.net.URI;

/**
 * .Clients
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/12/16 14:19
 */
public class Clients {

    private DiscoveryClient discoveryClient;

    public Clients(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    /**
     * get random service instance by id
     *
     * @param appId
     * @return
     */
    public ServiceInstance getRandomServiceInstanceById(String appId) {
        if (this.discoveryClient != null) {
            if (discoveryClient.getServices().stream().anyMatch(s -> s.equals(appId))) {
                if (discoveryClient.getInstances(appId).stream().findAny().isPresent()) {
                    return discoveryClient.getInstances(appId).stream().findAny().get();
                }
            }
        }
        throw new DiscoverClientNotFoundException(appId);
    }

    /**
     * get random service uri
     *
     * @param appId
     * @return
     */
    public URI getRandomServiceURI(String appId) {
        return getRandomServiceInstanceById(appId).getUri();
    }
}
