<@c.page title="账户管理" cssPaths=["/webjars/AdminLTE/plugins/datatables/dataTables.bootstrap.css"] jsPaths=["/webjars/AdminLTE/plugins/datatables/jquery.dataTables.min.js","/webjars/AdminLTE/plugins/datatables/dataTables.bootstrap.min.js","/js/auth/users.js"] tag=40>
<section class="content-header">
    <h1>
        账户管理
        <small>账户维护授权</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> 权限管理</a></li>
        <li class="active">账户管理</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">账户列表</h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-toggle="modal" data-target="#modal-add-user" title="添加账户"><i
                        class="fa fa-plus-circle"></i></button>
            </div>
        </div>
        <div class="box-body">
            <table id="usersTable" class="table table-bordered table-hover dataTable">
                <thead>
                <tr>
                    <th>账户名称</th>
                    <th>账户别名</th>
                    <th>是否启用</th>
                    <th>是否过期</th>
                    <th>是否锁住</th>
                    <th>更新时间</th>
                    <th>创建时间</th>
                    <th style="width: 80px">操作</th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
        <div class="box-footer">
        </div>
    </div>

</section>

<div class="modal modal-default fade" id="modal-add-user" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span></button>
                <h4 class="modal-title">添加账户</h4>
            </div>
            <div class="modal-body">
                <form id="saveUser" class="form-horizontal" action="/auth/user/add" method="post" enctype="application/x-www-form-urlencoded; charset=UTF-8">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="inputID" class="col-sm-2 control-label">账户名称</label>

                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="username" placeholder="登录名称">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPath" class="col-sm-2 control-label">账户别名</label>

                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="alias" placeholder="展示名称">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputUrl" class="col-sm-2 control-label">账户密码</label>

                            <div class="col-sm-10">
                                <input type="password" class="form-control" name="password" placeholder="">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="inputUrl" class="col-sm-2 control-label">用户角色</label>

                            <div class="col-sm-10 roles-ctx">
                                <#list roles as role>
                                    <div class="checkbox" style="padding-right: 20px; float: left; width: 200px">
                                        <label>
                                            <input name="roleIds" type="checkbox" value="${role.id!}">
                                            ${role.alias!}
                                        </label>
                                    </div>
                                </#list>

                            </div>
                        </div>

                        <#if _csrf??>
                            <input type="hidden" id="csrf_token" name="${_csrf.parameterName!}" value="${_csrf.token!}"/>
                        </#if>

                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-info pull-right">保存</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

</@c.page>