/**
 * .logs
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/4 10:11
 */
$(function () {
    // debugger;
    var logsTable;

    init();

    function init() {
        addEventListeners();
        loadServices();
    }

    function loadServices() {
        $.ajax({
            // url: '/api/v1/services',
            url: '/log/rest/services',
            success: function (data) {
                if (data) {
                    data.forEach(function (e) {
                        $('#app-services').append('<option>' + e + '</option>');
                    });
                    getServiceSpans(data[0]);
                }
            }
        });
    }

    function addEventListeners() {
        $('#app-services').change(function () {
            getServiceSpans($('#app-services').val());
        });
        $('#log-search').click(function (evt) {
            getTrace();
        });
    }

    function getServiceSpans(service) {
        $.ajax({
            // url: '/api/v1/spans?serviceName=' + service,
            url: '/log/rest/spans?serviceName=' + service,
            success: function (data) {
                $('#service-spans').empty();
                if (data) {
                    data.forEach(function (e) {
                        $('#service-spans').append('<option>' + e + '</option>');
                    });
                }
            }
        });
    }

    function getTrace() {

        var ranges = $('#time-range').val().split("-");
        var s = new Date(ranges[0]).getTime(), e = new Date(ranges[1]).getTime(), l = e - s;
        var q = {
            serviceName: $('#app-services').val(),
            spanName: $('#service-spans').val(),
            // lookback: l,
            startTs: s,
            endTs: e,
            // minDuration: '',
            lookback: l,
            limit: 20,
            annotationQuery: $('#anno-query').val(),
            sortOrder: 'duration-desc'
        };
        $.ajax({
            // url: '/api/v1/traces',
            url: '/log/rest/traces',
            data: q,
            medth: 'GET',
            success: function (data) {
                clear();
                refreshLogsTable(data);
            }
        });
    }

    var max_duration = 0;

    function clear() {
        max_duration = 0;
    }

    function refreshLogsTable(data) {
        if (!data) return;
        var dt = [];
        data.forEach(function (e) {
            //

            var f = e[0], dn = f.duration, ts = f.timestamp;
            if (dn >= max_duration) max_duration = dn;
            dt.push({
                traceId: e[0].traceId,
                duration: dn,
                services: getUServices(e),
                status: checkStatus(e),
                timestamp: ts
            })
        });
        // dt.reverse();

        logsTable = $('#logsTable').DataTable({
            destroy: true,
            autoWidth: false,
            paging: false,
            data: dt,
            order: [[0, 'desc']],
            columnDefs: [
                {
                    targets: 1,
                    data: null,
                    render: function (data, type, row, meta) {
                        var p = Math.floor((data || 0) * 100 / max_duration), p = p < 5 ? 5 : p;
                        return '<div class="progress progress-xs progress-striped active"><div class="progress-bar progress-bar-' + (row.status == 0 ? 'success' : 'danger') + '" style="width: ' + p + '%"></div></div>';
                    }
                },
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        var s = '';
                        data.forEach(function (e) {
                            s += '<span class="badge bg-green">' + e + '</span>&nbsp;';
                        });
                        return s;
                    }
                },
                {
                    targets: 3,
                    data: null,
                    render: function (data, type, row, meta) {
                        // return new Date(data/1000);
                        return new moment(data / 1000).format('YYYY-MM-DD HH:mm:ss');
                    }
                },
                {
                    targets: 4,
                    data: null,
                    render: function (data, type, row, meta) {
                        var l = '';
                        if (data == 0) l += '<span class="label label-success">正常</span>';
                        else l += '<span class="label label-danger">异常</span>';
                        return l += '<a class="btn btn-info btn-xs" style="margin-left: 10px" href="/cs/logs/detail/' + row.traceId + '">详情</a>';
                    }
                }
                // {
                //     targets: 5,
                //     data: null,
                //     render: function (data, type, row, meta) {
                //         return;
                //     }
                // }
            ],
            columns: [
                {"data": "duration"},
                {"data": "duration"},
                {"data": "services"},
                {"data": "timestamp"},
                {"data": "status"}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });

        function getUServices(data) {
            if (!data) return;
            var ss = [];
            data.forEach(function (e1) {
                var ba = e1.binaryAnnotations;
                ba.forEach(function (e2) {
                    var sn = e2.endpoint.serviceName;
                    if (ss.indexOf(sn) == -1) ss.push(sn);
                });
            });
            return ss;
        }

        /**
         * normal 0
         * error 1
         * @param data
         */
        function checkStatus(data) {
            var b = false;
            data.forEach(function (e1) {
                var ba = e1.binaryAnnotations;
                ba.forEach(function (e2) {
                    if ('error' == e2.key) b = true;
                });
            });
            return b ? 1 : 0;
        }

    }


    $('#time-range').daterangepicker({
        "timePicker": true,
        "timePickerSeconds": true,
        "timePickerIncrement": 10,
        "startDate": moment().startOf('day'),
        "showCustomRangeLabel": false,
        "ranges": {
            '一分钟内': [moment().subtract(1, 'minute'), moment()],
            '十分钟内': [moment().subtract(10, 'minute'), moment()],
            '一小时内': [moment().subtract(60, 'minute'), moment()],
            '今天': [moment().startOf('day'), moment()],
            '一天内': [moment().subtract(1, 'days'), moment()],
            '两天内': [moment().subtract(2, 'days'), moment()],
            '一周内': [moment().subtract(7, 'days'), moment()]
        },
        "locale": {
            "format": 'YYYY/MM/DD HH:mm:ss',
            "daysOfWeek": [
                "周日",
                "周一",
                "周二",
                "周三",
                "周四",
                "周五",
                "周六"
            ],
            "monthNames": [
                "一月",
                "二月",
                "三月",
                "四月",
                "五月",
                "六月",
                "七月",
                "八月",
                "九月",
                "十月",
                "十一月",
                "十二月"
            ]
        }
    }, function (start, end, label) {

    });

});