/**
 * .logs-detail
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/6 9:42
 */
$(function () {

    var _item_tpl = '<div class="row">\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2">\n' +
        '                            <span class="label label-success">{0}</span>\n' +
        '                            <span class="label label-info">{1}</span>\n' +
        '                        </div>\n' +
        '                        <div class="col-md-10 col-sm-10 col-xs-10">\n' +
        '                            <div class="progress" data-toggle="tooltip" title="{6}">\n' +
        '                                <div class="progress-bar progress-bar-{5}" style="width: {2}%; margin-left: {4}%">\n' +
        '                                    <span class="pull-right">{3}</span>\n' +
        '                                </div>\n' +
        '                            </div>\n' +
        '                        </div>\n' +
        '                    </div>';
    var _ht = '<div class="col-md-2 col-sm-2 col-xs-2">服务名</div>\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2"><span class="pull-right">{0}</span></div>\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2"><span class="pull-right">{1}</span></div>\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2"><span class="pull-right">{2}</span></div>\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2"><span class="pull-right">{3}</span></div>\n' +
        '                        <div class="col-md-2 col-sm-2 col-xs-2"><span class="pull-right">{4}</span></div>';


    init();

    function init() {
        loadTrace(traceId);
    }

    function loadTrace(traceId) {
        $.ajax({
            // url: '/api/v1/trace/' + traceId,
            url: '/log/rest/trace/' + traceId,
            success: function (data) {
                setDetail(data);
                renderList(data);
                showServiceRef(data);
            }
        });
    }

    var maxDuration, firstTS;

    function renderList(data) {
        clear();
        if (data) {
            data.forEach(function (e) {
                addItem(e);
            });
            setHeader();
        }

        function clear() {
            $('#ctx').empty();
            $('#ht').empty();
            maxDuration = 0;
            firstTS = 0;
        }

        function setHeader() {
            var dt = maxDuration / 5;
            $('#ht').append(_ht.format((dt * 1).toFixed(0), (dt * 2).toFixed(0), (dt * 3).toFixed(0), (dt * 4).toFixed(0), (dt * 5).toFixed(0)));
        }

        function addItem(item) {
            var sn = getServiceName(item), mn = item.name, d = item.duration, t = item.timestamp;
            if (maxDuration == 0) maxDuration = d;
            if (firstTS == 0) firstTS = t;
            var p = (d * 100 / maxDuration).toFixed(2);
            var ts = t - firstTS, pt = (ts * 100 / maxDuration).toFixed(2);
            var error = checkError(item), eb = error.error;

            $('#ctx').append(_item_tpl.format(sn, mn, p, d, pt, eb ? 'danger' : 'aqua', error.msg));

            function checkError(item) {
                var e = {error: false, msg: ''};
                if (item && item.binaryAnnotations) {
                    var ba = item.binaryAnnotations;
                    for (var i = 0; i < ba.length; i++) {
                        if (ba[0].key == 'error') {
                            e = {error: true, msg: ba[0].value};
                            break;
                        }
                    }
                }
                return e;
            }
        }
    }

    function getServiceName(item) {
        if (!item) return;
        var sn;
        if (item.annotations) {
            var anno = item.annotations, sn;
            for (var i = 0; i < anno.length; i++) {
                var v = anno[i].value;
                if (v == 'ss' || v == 'sr') sn = anno[i].endpoint.serviceName;
            }
            if (!sn) sn = item.annotations[0].endpoint.serviceName;
        } else if (item.binaryAnnotations) {
            sn = item.binaryAnnotations[0].endpoint.serviceName;
        }
        return sn;
    }

    function setDetail(data) {
        $('#modal-msg .modal-body pre').empty();
        $('#modal-msg .modal-body pre').append(JSON.stringify(data, null, 2));
    }

    function showServiceRef(data) {
        var nd = ogd(data);
        var chart = echarts.init($('#serviceRefD')[0]);
        chart.setOption(option = {
            title: {},
            animationDurationUpdate: 1500,
            animationEasingUpdate: 'quinticInOut',
            series: [
                {
                    type: 'graph',
                    layout: 'none',
                    edgeSymbol: ['circle', 'arrow'],
                    edgeSymbolSize: [4, 8],
                    data: nd.nodes.map(function (node) {
                        return {
                            x: node.x,
                            y: node.y,
                            id: node.id,
                            name: node.label,
                            symbolSize: 15,
                            itemStyle: {
                                normal: {
                                    color: '#00c0ef'
                                }
                            }
                        };
                    }),
                    edges: nd.edges.map(function (edge) {
                        return {
                            source: edge.sourceID,
                            target: edge.targetID
                        };
                    }),
                    label: {
                        emphasis: {
                            position: 'right',
                            show: true
                        }
                    },
                    roam: true,
                    focusNodeAdjacency: true,
                    lineStyle: {
                        normal: {
                            width: 1,
                            curveness: 0.3,
                            opacity: 0.7
                        }
                    }
                }
            ]
        }, true);

        function ogd(data) {
            var nodes = [], edges = [], i = 0;
            if (data) {
                data.forEach(function (e) {
                    var sn = getServiceName(e);
                    nodes.push({id: e.id, label: sn, x: i, y: i});
                    if (e.parentId) {
                        // has ref
                        edges.push({sourceID: e.parentId, targetID: e.id});
                    }
                    i += 25;
                })
            }
            return {nodes: nodes, edges: edges};
        }
    }


});