/**
 * .loadb
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/8/31 14:09
 */
$(function () {
    //
    var hyTable, MAX_REQUEST_COUNT = 2000;

    init();

    function init() {
        initHyTable();
        getHytrixInfo();
    }

    function getHytrixInfo() {
        var es = new EventSource('/admin/api/turbine/stream?cluster=default');
        es.addEventListener("message", function (evt) {
            refreshHyData(evt.data);
        })
    }

    function refreshHyData(data) {
        debugger;
        if (!data) return;
        if (typeof data == "string") data = JSON.parse(data);
        if (data.type != "HystrixCommand") return;
        //
        var idx = hyTable.rows().eq(0).filter(function (rowIdx) {
            return hyTable.cell(rowIdx, 1).data() == data.name ? true : false;
        });
        hyTable.rows(idx).remove();
        hyTable.row.add(data).draw();
    }

    function initHyTable() {
        hyTable = $('#hyTable').DataTable({
            destroy: false,
            paging: true,
            data: [],
            columnDefs: [
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        return requestProBar(data);
                    }
                },
                {
                    targets: 3,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<span class="badge bg-green">' + data + '</span>';
                    }
                },
                {
                    targets: 4,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<span class="badge bg-red">' + data + '</span>';
                    }
                },
                {
                    targets: 8,
                    data: null,
                    render: function (data, type, row, meta) {
                        if (data) return '<span class="label label-danger">开启</span>';
                        else return '<span class="label label-success">关闭</span>';
                    }
                }

            ],
            columns: [
                {"data": "group"},
                {"data": "name"},
                {"data": "requestCount"},
                {"data": "rollingCountSuccess"},
                {"data": "errorPercentage"},
                {"data": "latencyTotal_mean"},
                {"data": "latencyTotal.95"},
                {"data": "latencyTotal.99"},
                {"data": "isCircuitBreakerOpen"},
                {"data": "rollingCountTimeout"},
                {"data": "rollingCountThreadPoolRejected"}

            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });

        function requestProBar(count) {
            var p = Math.floor(count * 100 / MAX_REQUEST_COUNT);
            return '<div class="progress progress-xs progress-striped active"><div class="progress-bar progress-bar-success" style="width: ' + p + '%"></div></div>';
        }
    }
});