/**
 * .gateway
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/20 11:22
 */
$(function () {

    init();

    function init() {
        refreshRoutes();
        initEventListeners();
    }

    function initEventListeners() {
        $("#rTable ").on('click', '.b-r-delete', function (evt, e1, e2) {
            var path = $(evt.target).attr('dt');
            deleteRoute(path);
        });
        $("#saveRoute").submit(function (evt) {
            debugger;
            var id = $("#inputID").val(), path = $("#inputPath").val(), url = $("#inputUrl").val();
            saveRoute(id, path, url);
        });
        $("#iTable ").on('click', '.b-r-delete', function (evt, e1, e2) {
            var serviceId = $(evt.target).attr('dt');
            resumeService(serviceId);
        });
        $("#saveServiceId").submit(function (evt) {
            debugger;
            var serviceId = $("#inputServiceId").val();
            ignoreService(serviceId);
        });
    }

    function refreshRoutes() {
        $.ajax({
            url: '/rest/gw/routes',
            success: function (data) {
                refreshTable(data);
            }
        });

        $.ajax({
            url: '/rest/gw/list',
            success: function (data) {
                refreshRTable(data);
            }
        });

        $.ajax({
            url: '/rest/gw/services',
            success: function (data) {
                refreshITable(data);
            }
        });
    }

    function refreshTable(data) {
        var rs = [];
        $.each(data, function (i, v) {
            rs.push({k: i, v: v});
        });
        $('#gwTable').DataTable({
            destroy: true,
            paging: false,
            data: rs,
            columns: [
                {"data": "k"},
                {"data": "v"}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });

    }

    function refreshRTable(data) {
        $('#rTable').DataTable({
            destroy: true,
            paging: false,
            data: data,
            columnDefs: [
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<a class="btn btn-danger btn-xs b-r-delete" href="#" dt="' + data + '">删除</a>';
                    }
                }
            ],
            columns: [
                {"data": "path"},
                {"data": "url"},
                {"data": "path"}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });
    }

    function refreshITable(data) {
        var is = [];
        $.each(data, function (i, v) {
            is.push({s: v})
        });
        $('#iTable').DataTable({
            destroy: true,
            paging: false,
            data: is,
            columnDefs: [
                {
                    targets: 1,
                    data: null,
                    render: function (data, type, row, meta) {
                        if (data == "gateway-app") return '';
                        return '<a class="btn btn-danger btn-xs b-r-delete" href="#" dt="' + data + '">删除</a>';
                    }
                }
            ],
            columns: [
                {"data": "s"},
                {"data": "s"}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });
    }

    function saveRoute(id, path, url) {
        $.ajax({
            url: '/rest/gw/add',
            data: {
                id: id,
                path: path,
                url: url
            },
            success: function (evt) {
                refreshRoutes();
                $("#modal-add-route").modal('hide');
            }
        });
    }

    function deleteRoute(path) {
        $.ajax({
            url: '/rest/gw/delete',
            data: {
                path: path
            },
            success: function () {
                refreshRoutes();
            }
        });
    }

    function resumeService(data) {
        $.ajax({
            url: '/rest/gw/service/resume',
            data: {
                serviceId: data
            },
            success: function (data) {
                refreshRoutes();
            }
        });
    }

    function ignoreService(data) {
        $.ajax({
            url: '/rest/gw/service/ignore',
            data: {
                serviceId: data
            },
            success: function (data) {
                refreshRoutes();
                $("#modal-add-serviceId").modal('hide');
            }
        });
    }
});