/**
 * .register
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/8/29 16:21
 */

$(function () {

    $.ajax({
        url: '/admin/api/applications',
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            refreshTable(data);
        }
    });

    function refreshTable(data) {
        $('#serviceTable').DataTable({
            processing: true,
            paging: true,
            // ajax:{
            //     url:'/admin/api/applications',
            //     dataSrc:''
            // },
            data: data,
            // order: [[0, 'desc']],
            columnDefs: [
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        return JSON.stringify(data);
                    }
                },
                {
                    targets: 3,
                    data: null,
                    render: function (data, type, row, meta) {
                        return new Date(data).toLocaleString("zh-CN", {hour12: false});
                    }
                },
                {
                    targets: 4,
                    data: null,
                    render: function (data, type, row, meta) {
                        if (data == "UP") return '<span class="label label-success">正常</span><a class="btn btn-info btn-xs" style="margin-left: 10px" href="/cs/register/app/' + row.id + '">详情</a>';
                        else return '<span class="label label-danger">离线</span>';
                    }
                }
            ],
            columns: [
                {"data": "name"},
                {"data": "serviceUrl"},
                {"data": "info"},
                {"data": "statusInfo.timestamp"},
                {"data": "statusInfo.status"}

            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });
    }

    //
});