/**
 * .app
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/8/30 8:32
 */
$(function () {

    var hyTable, threadTable, MAX_REQUEST_COUNT = 2000, MAX_LOG_LENGTH = 50000;

    init();

    function init() {
        getAppInfo();
        getHealthInfo();
        getMetricsInfo();
        initHyTable();
        getHytrixInfo();
        initThreadTable();
        initEnvTable();
        getApptLog();
        setInterval(refresh, 5000);
    }

    function refresh() {
        getHealthInfo();
        getMetricsInfo();
        refreshTHTable();
    }

    function getAppInfo() {
        $.ajax({
            url: '/admin/api/applications/' + appId,
            success: function (data) {
                // debugger;
            }
        });
    }

    function getHealthInfo() {
        $.ajax({
            url: '/admin/api/applications/' + appId + '/health',
            success: function (data) {
                setDiskInfo(data);
            }
        });
    }

    function getMetricsInfo() {
        $.ajax({
            url: '/admin/api/applications/' + appId + '/metrics',
            success: function (data) {
                setMemInfo(data);
                setJVMInfo(data);
            }
        });
    }

    /**
     * set mem info
     * @param data
     */
    function setMemInfo(data) {
        var free = data['mem.free'], total = data.mem, used = total - free, rat = Math.round(used * 100 / total);
        $('#mem-used').text(bytesToSize(used * 1024));
        $('#men-percent').css('width', rat + '%');
        $('#mem-dt').text('内存使用率 ' + rat + '% ( ' + bytesToSize(free * 1024) + ' / ' + bytesToSize(total * 1024) + ' )');
        checkFreeSpace($('#mem-box'), rat);
    }

    /**
     *
     * @param data
     */
    function setDiskInfo(data) {
        var free = data.diskSpace.free, total = data.diskSpace.total, used = total - free,
            rat = Math.round(used * 100 / total);
        $('#disk-used').text(bytesToSize(used));
        $('#disk-percent').css('width', rat + '%');
        $('#disk-dt').text('磁盘使用率 ' + rat + '% ( ' + bytesToSize(free) + ' / ' + bytesToSize(total) + ' )');
        checkFreeSpace($('#disk-box'), rat);
    }

    /**
     *
     * @param data
     */
    function setJVMInfo(data) {
        $('#d-uptime').text(gt.util.dateIntervalFormat(data.uptime));
        $('#cpu-core').text('CPU核心数：' + data.processors);
        $('#thread-info').text('线程数：' + data.threads + ' 会话数：' + data['httpsessions.active']);
    }

    /**
     *
     */
    function getHytrixInfo() {
        var es = new EventSource('/admin/api/applications/' + appId + '/hystrix.stream');
        es.addEventListener("message", function (evt) {
            refreshHyData(evt.data);
        })

    }

    /**
     * refresh hy data
     *
     * @param data
     */
    function refreshHyData(data) {
        // debugger;
        if (!data) return;
        if (typeof data == "string") data = JSON.parse(data);
        //
        var idx = hyTable.rows().eq(0).filter(function (rowIdx) {
            return hyTable.cell(rowIdx, 0).data() == data.name ? true : false;
        });
        hyTable.rows(idx).remove();
        hyTable.row.add(data).draw();
    }

    function initHyTable() {
        hyTable = $('#hyTable').DataTable({
            destroy: false,
            paging: false,
            data: [],
            columnDefs: [
                {
                    targets: 1,
                    data: null,
                    render: function (data, type, row, meta) {
                        return requestProBar(data);
                    }
                },
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<span class="badge bg-green">' + data + '</span>';
                    }
                },
                {
                    targets: 3,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<span class="badge bg-red">' + data + '</span>';
                    }
                },
                {
                    targets: 7,
                    data: null,
                    render: function (data, type, row, meta) {
                        if (data) return '<span class="label label-danger">开启</span>';
                        else return '<span class="label label-success">关闭</span>';
                    }
                }

            ],
            columns: [
                {"data": "name"},
                {"data": "requestCount"},
                {"data": "rollingCountSuccess"},
                {"data": "errorPercentage"},
                {"data": "latencyExecute_mean"},
                {"data": "latencyTotal.95"},
                {"data": "latencyTotal.99"},
                {"data": "isCircuitBreakerOpen"},
                {"data": "rollingCountTimeout"},
                {"data": "rollingCountThreadPoolRejected"}

            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });

        function requestProBar(count) {
            var p = Math.floor(count * 100 / MAX_REQUEST_COUNT);
            return '<div class="progress progress-xs progress-striped active"><div class="progress-bar progress-bar-success" style="width: ' + p + '%"></div></div>';
        }
    }

    function initThreadTable() {
        threadTable = $('#threadTable').DataTable({
            destroy: false,
            autoWidth: false,
            paging: true,
            ajax: {
                url: '/admin/api/applications/' + appId + '/dump',
                dataSrc: ''
            },
            columnDefs: [
                {
                    targets: 1,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<span style="overflow-x:hidden;overflow-y:hidden;word-wrap:break-word;">' + data + '</span>';
                    }
                },
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        if (data == 'RUNNABLE') return '<span class="label label-success">' + data + '</span>';
                        else if (data == 'WAITING' || data == 'TIMED_WAITING') return '<span class="label label-warning">' + data + '</span>';
                        else return '<span class="label label-danger">' + data + '</span>';
                    }
                }
            ],
            columns: [
                {"data": "threadId"},
                {"data": "threadName"},
                {"data": "threadState"}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });

    }

    function refreshTHTable() {
        if (threadTable) threadTable.ajax.reload();
    }

    /**
     * init env table
     */
    function initEnvTable() {
        $.ajax({
            url: '/admin/api/applications/' + appId + '/env',
            success: function (data) {
                var vd = [];
                var fd = Object.keys(data).filter(function (t) {
                    return t.startsWith('applicationConfig')
                });
                fd.forEach(function (e1) {
                    var d = data[e1];
                    var ks = Object.keys(d);
                    ks.forEach(function (k) {
                        vd.push({k: k, v: d[k]});
                    });
                });
                setEnvData(vd);
            }
        });

        function setEnvData(data) {
            $('#envTable').DataTable({
                destroy: false,
                autoWidth: false,
                paging: true,
                data: data,
                columns: [
                    {"data": "k"},
                    {"data": "v"}
                ],
                language: {
                    url: "/assets/dt_zh_cn.md"
                }
            });
        }

    }


    function getApptLog() {
        $.ajax({
            url: '/admin/api/applications/' + appId + '/logfile',
            success: function (data) {
                if (data.length >= MAX_LOG_LENGTH) $('#log-t').text(data.substring(data.length - MAX_LOG_LENGTH, data.length));
                else $('#log-t').text(data);
            }
        });
    }

    function bytesToSize(bytes) {
        return gt.util.byteFormat(bytes);
    }

    function checkFreeSpace(ele, percent) {
        if (percent > 80) {
            ele.removeClass('bg-yellow bg-aqua').addClass('bg-red');
        } else if (percent > 70) {
            ele.removeClass('bg-aqua bg-red').addClass('bg-yellow');
        } else {
            ele.removeClass('bg-yellow bg-red').addClass('bg-aqua');
        }
    }

});