/**
 * .common
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/9/4 14:24
 */
gt = {
    util: {
        dateIntervalFormat: function (interval) {
            if (!interval) return;
            var days = Math.floor(interval / (24 * 3600 * 1000));
            var l1 = interval % (24 * 3600 * 1000), hours = Math.floor(l1 / (3600 * 1000));
            var l2 = l1 % (3600 * 1000), minutes = Math.floor(l2 / (60 * 1000));
            var l3 = l2 % (60 * 1000), seconds = Math.floor(l3 / 1000);
            var f = '';
            if (days > 0) f += days + '天';
            if (hours > 0) f += hours + '小时';
            if (minutes > 0) f += minutes + '分';
            if (seconds >= 0) f += seconds + '秒';
            return f;
        },
        byteFormat: function (bytes) {
            if (bytes === 0) return '0 B';
            var k = 1024,
                sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
                i = Math.floor(Math.log(bytes) / Math.log(k));
            return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
        }
    }
};

/**
 *
 * @returns {String}
 */
String.prototype.format = function () {
    if (!arguments || arguments.length == 0) return this;
    for (var s = this, i = 0; i < arguments.length; i++) {
        s = s.replace(new RegExp("\\{" + i + "\\}", "g"), arguments[i]);
    }
    return s;
}