/**
 * .users
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/10 18:48
 */
$(function () {

    init();

    function init() {
        initUserTable();
        initEventListeners();
    }

    function getUsers() {

    }

    function initEventListeners() {
        $("#usersTable ").on('click', '.b-r-delete', function (evt, e1, e2) {
            var id = $(evt.target).attr('dt');
            deleteUser(id);
        });
        $("#usersTable ").on('click', '.b-r-edit', function (evt, e1, e2) {
            var id = $(evt.target).attr('dt');
            editUser(id);
        });


    }

    function editUser(id) {

    }

    function deleteUser(id) {

    }

    function initUserTable() {
        $("#usersTable").DataTable({
            paging: true,
            serverSide: true,
            ajax: {
                url: '/auth/rest/users'
                // dataSrc: 'data'
            },
            columnDefs: [
                {
                    targets: 2,
                    data: null,
                    render: function (data, type, row, meta) {
                        return data ? '<span class="label label-success">启用</span>' : '<span class="label label-warning">禁用</span>';
                    }
                },
                {
                    targets: 3,
                    data: null,
                    render: function (data, type, row, meta) {
                        return !data ? '<span class="label label-success">否</span>' : '<span class="label label-warning">是</span>';
                    }
                },
                {
                    targets: 4,
                    data: null,
                    render: function (data, type, row, meta) {
                        return !data ? '<span class="label label-success">否</span>' : '<span class="label label-warning">是</span>';
                    }
                },
                {
                    targets: 7,
                    data: null,
                    render: function (data, type, row, meta) {
                        return '<a class="btn btn-info btn-xs b-r-edit" href="#" dt="' + data + '">编辑</a>'+
                            '<a class="btn btn-danger btn-xs b-r-delete" style="margin-left: 10px" href="#" dt="' + data + '">删除</a>';
                    }
                }
            ],
            columns: [
                {data: 'username'},
                {data: 'alias'},
                {data: 'enabled'},
                {data: 'expired'},
                {data: 'locked'},
                {data: 'updateAt'},
                {data: 'createAt'},
                {data: 'id'}
            ],
            language: {
                url: "/assets/dt_zh_cn.md"
            }
        });
    }
});