/**
 * .region
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/10/13 9:10
 */
$(function () {

    var setting = {
        async: {
            enable: true,
            url: '/auth/rest/regions?' + csrf_name + '=' + csrf_token,
            type: 'get',
            autoParam: ['id']
        },
        callback: {
            beforeClick: function (treeId, treeNode) {
                debugger;
                getRegions(treeNode);
            }
        }
    };
    var tree;

    init();

    function init() {
        initTree();
    }

    function initTree() {
        tree = $.fn.zTree.init($("#regionTree"), setting);
    }

    function getRegions(treeNode) {
        $('#parentId').val(treeNode.id);
        if (treeNode.children) return;
        $.ajax({
            url: '/auth/rest/regions?' + csrf_name + '=' + csrf_token,
            data: {
                id: treeNode.id
            },
            success: function (data) {
                debugger;
                if (data && data.length > 0) tree.addNodes(treeNode, 0, data);
            }
        });
    }
});