/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.admin.web.rest;

import cn.gtmap.gtcc.admin.clients.CollectorClient;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/log/rest/"})
public class LogTraceController {
    @Autowired
    CollectorClient collectorClient;

    @RequestMapping(value={"/services"})
    public List getServices() {
        return this.collectorClient.getServices();
    }

    @RequestMapping(value={"/spans"})
    public List getServices(@RequestParam(value="serviceName") String serviceName) {
        return this.collectorClient.getSpansByServiceName(serviceName);
    }

    @RequestMapping(value={"/traces"})
    public List getTraces(@RequestParam(value="serviceName", required=false) String serviceName, @RequestParam(value="spanName", defaultValue="all") String spanName, @RequestParam(value="annotationQuery", required=false) String annotationQuery, @RequestParam(value="minDuration", required=false) Long minDuration, @RequestParam(value="maxDuration", required=false) Long maxDuration, @RequestParam(value="endTs", required=false) Long endTs, @RequestParam(value="lookback", required=false) Long lookback, @RequestParam(value="limit", required=false) Integer limit) {
        return this.collectorClient.getTraces(serviceName, spanName, annotationQuery, minDuration, maxDuration, endTs, lookback, limit);
    }

    @RequestMapping(value={"/trace/{traceId}"})
    List getTraceBtTraceId(@PathVariable(name="traceId") String traceId) {
        return this.collectorClient.getTraceBtTraceId(traceId);
    }
}

