/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.admin.web.rest;

import cn.gtmap.gtcc.admin.clients.AuthClient;
import cn.gtmap.gtcc.admin.clients.ClientClient;
import cn.gtmap.gtcc.admin.support.DTPage;
import cn.gtmap.gtcc.clients.region.RegionClient;
import cn.gtmap.gtcc.clients.sec.DepartmentClient;
import cn.gtmap.gtcc.clients.sec.RoleClient;
import cn.gtmap.gtcc.clients.sec.UserClient;
import cn.gtmap.gtcc.domain.region.Region;
import cn.gtmap.gtcc.domain.sec.Authority;
import cn.gtmap.gtcc.domain.sec.Client;
import cn.gtmap.gtcc.domain.sec.Department;
import cn.gtmap.gtcc.domain.sec.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth/rest"})
public class AuthRestController {
    @Autowired
    UserClient userClient;
    @Autowired
    RoleClient roleClient;
    @Autowired
    DepartmentClient departmentClient;
    @Autowired
    AuthClient authClient;
    @Autowired
    ClientClient clientClient;
    @Autowired
    RegionClient regionClient;

    @GetMapping(value={"/users"})
    public DTPage<User> users(@RequestParam(name="start", defaultValue="0") int start, @RequestParam(name="draw", defaultValue="0") int draw, @RequestParam(name="length", defaultValue="10") int length) {
        return DTPage.builder((int)draw, (Page)this.userClient.getUsers((Pageable)new PageRequest(start / length, length)));
    }

    @GetMapping(value={"/roles"})
    public DTPage<User> roles(@RequestParam(name="start", defaultValue="0") int start, @RequestParam(name="draw", defaultValue="0") int draw, @RequestParam(name="length", defaultValue="10") int length) {
        return DTPage.builder((int)draw, (Page)this.roleClient.getRoles((Pageable)new PageRequest(start / length, length)));
    }

    @GetMapping(value={"/departments"})
    public Iterable<Department> getDepartments(@RequestParam(required=false) String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return this.departmentClient.getRootDepartments();
        }
        return this.departmentClient.getChildren(id);
    }

    @GetMapping(value={"/authorities"})
    public DTPage<Authority> getAuthorities(@RequestParam(name="start", defaultValue="0") int start, @RequestParam(name="draw", defaultValue="0") int draw, @RequestParam(name="length", defaultValue="10") int length) {
        return DTPage.builder((int)draw, (Page)this.authClient.getAllAuthorities((Pageable)new PageRequest(start / length, length)));
    }

    @GetMapping(value={"/clients"})
    public DTPage<Client> getClients(@RequestParam(name="start", defaultValue="0") int start, @RequestParam(name="draw", defaultValue="0") int draw, @RequestParam(name="length", defaultValue="10") int length) {
        return DTPage.builder((int)draw, (Page)this.clientClient.getClients((Pageable)new PageRequest(start / length, length)));
    }

    @PostMapping(value={"/client/add"})
    public Client addClient(@RequestBody Client client) {
        return this.clientClient.addClient(client);
    }

    @GetMapping(value={"/regions"})
    public Iterable<Region> getRegions(@RequestParam(required=false) String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return this.regionClient.getRootRegion();
        }
        return this.regionClient.getChildren(id);
    }
}

