/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.admin.web;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/cs"})
public class CloudServicesController {
    private final ApplicationRegistry registry;

    public CloudServicesController(ApplicationRegistry registry) {
        this.registry = registry;
    }

    @GetMapping(value={"/register/apps"})
    public String register() {
        return "cs/apps";
    }

    @GetMapping(value={"/register/app/{id}"})
    public String getApp(@PathVariable(name="id") String id, Model model) {
        Application application = this.registry.getApplication(id);
        model.addAttribute("appId", (Object)id);
        model.addAttribute("name", (Object)application.getName());
        model.addAttribute("statusInfo", (Object)application.getStatusInfo());
        return "cs/app";
    }

    @GetMapping(value={"/loadb"})
    public String loadBalance() {
        return "cs/loadb";
    }

    @GetMapping(value={"/logs"})
    public String logs() {
        return "cs/logs";
    }

    @GetMapping(value={"/logs/detail/{traceId}"})
    public String logDetail(@PathVariable(name="traceId") String traceId, Model model) {
        model.addAttribute("traceId", (Object)traceId);
        return "cs/logs-detail";
    }

    @GetMapping(value={"/gateway/routes"})
    public String gatewayRoute(Model model) {
        return "cs/gateway";
    }
}

