/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.admin.web;

import cn.gtmap.gtcc.admin.clients.ClientClient;
import cn.gtmap.gtcc.admin.support.DTDepartment;
import cn.gtmap.gtcc.admin.support.DTUser;
import cn.gtmap.gtcc.clients.sec.DepartmentClient;
import cn.gtmap.gtcc.clients.sec.RoleClient;
import cn.gtmap.gtcc.clients.sec.UserClient;
import cn.gtmap.gtcc.domain.sec.Department;
import cn.gtmap.gtcc.domain.sec.Role;
import cn.gtmap.gtcc.domain.sec.User;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/auth"})
public class AuthorityController {
    @Autowired
    UserClient userClient;
    @Autowired
    RoleClient roleClient;
    @Autowired
    DepartmentClient departmentClient;
    @Autowired
    ClientClient clientClient;

    @GetMapping(value={"/users"})
    public String users(Model model) {
        model.addAttribute("roles", (Object)this.roleClient.getRoles((Pageable)new PageRequest(0, 1000)).getContent());
        return "auth/users";
    }

    @PostMapping(value={"/user/add"})
    public String addUser(DTUser user) {
        User u = this.userClient.addUser((User)user);
        this.userClient.updateUserRoles(u.getId(), Arrays.asList(user.getRoleIds()));
        return "redirect:/auth/users";
    }

    @GetMapping(value={"/roles"})
    public String roles(Model model) {
        return "auth/roles";
    }

    @PostMapping(value={"/role/add"})
    public String addRole(Role role) {
        this.roleClient.addRole(role);
        return "redirect:/auth/roles";
    }

    @GetMapping(value={"/departments"})
    public String departments(Model model) {
        return "auth/departments";
    }

    @PostMapping(value={"/department/add"})
    public String addDepartment(DTDepartment department) {
        this.departmentClient.addDepartment(StringUtils.isEmpty((Object)department.getParentId()) ? "root" : department.getParentId(), (Department)department);
        return "redirect:/auth/departments";
    }

    @GetMapping(value={"/authorities"})
    public String authorities(Model model) {
        return "auth/authorities";
    }

    @GetMapping(value={"/regions"})
    public String regions() {
        return "auth/region";
    }
}

