/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.zhgk.manage.web;

import cn.gtmap.api.ApiException;
import cn.gtmap.api.LeasClient;
import cn.gtmap.api.LeasRequest;
import cn.gtmap.api.LeasWfTjRequest;
import cn.gtmap.api.LeasWfTjResponse;
import cn.gtmap.api.LeasXchjRequest;
import cn.gtmap.api.LeasXchjResponse;
import cn.gtmap.api.LeasXctjRequest;
import cn.gtmap.api.LeasXctjResponse;
import cn.gtmap.busi.model.XcLjTj;
import cn.gtmap.busi.model.XcTj;
import cn.gtmap.gtc.zhgk.manage.service.ZfxcService;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ZfjcController", tags={"\u6267\u6cd5\u76d1\u5bdf"})
@RestController
@RequestMapping(value={"manage/zfxc"})
public class ZfxcController {
    @Autowired
    private ZfxcService zfxcService;
    private Logger logger = LoggerFactory.getLogger(ZfxcController.class);
    @Autowired
    private LeasClient leasClient;

    @GetMapping(value={"/getXctjData"})
    public Map<String, Object> getXctjData(@RequestParam(value="xzqdm") String xzqdm, @RequestParam(value="type") String type, @RequestParam(value="method") String method, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) {
        LeasXctjResponse response = null;
        LeasXctjRequest request = new LeasXctjRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("type", type);
        map.put("xzqdm", xzqdm);
        map.put("method", method);
        request.setJsonParam(JSON.toJSONString(map));
        try {
            response = (LeasXctjResponse)this.leasClient.execute((LeasRequest)request);
        }
        catch (ApiException e) {
            this.logger.error(e.getErrMsg());
        }
        ArrayList<String> hfzsList = new ArrayList<String>();
        ArrayList<String> hfmjList = new ArrayList<String>();
        ArrayList<String> wfzsList = new ArrayList<String>();
        ArrayList<String> wfmjList = new ArrayList<String>();
        ArrayList<String> xczcsList = new ArrayList<String>();
        ArrayList<String> xczglsList = new ArrayList<String>();
        ArrayList<String> xcfglList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> xcdksList = new ArrayList<String>();
        ArrayList<String> wyXcdksList = new ArrayList<String>();
        ArrayList<String> hyXcdksList = new ArrayList<String>();
        ArrayList xcdkmjList = new ArrayList();
        ArrayList<String> wyXcdmjList = new ArrayList<String>();
        ArrayList<String> hyXcdmjList = new ArrayList<String>();
        ArrayList<String> wptbzsList = new ArrayList<String>();
        ArrayList<String> wptbzmjList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)response.getResult())) {
            for (XcTj xcTj : response.getResult()) {
                wptbzsList.add(String.valueOf(Integer.parseInt(xcTj.getHfwpzs() + 0) + Integer.parseInt(xcTj.getWfwpzs())));
                wptbzmjList.add(String.format("%.2f", (Double.parseDouble(xcTj.getHfwpmj()) + Double.parseDouble(xcTj.getWfwpmj())) * 0.0015));
                hfzsList.add(xcTj.getHfwpzs());
                hfmjList.add(String.valueOf(Double.valueOf(xcTj.getHfwpmj()) * 0.0015));
                wfzsList.add(xcTj.getWfwpzs());
                wfmjList.add(String.valueOf(Double.valueOf(xcTj.getWfwpmj()) * 0.0015));
                xczcsList.add(xcTj.getXczcs());
                xczglsList.add(xcTj.getXczgl());
                xcfglList.add(String.valueOf(Double.parseDouble(xcTj.getXcfgl()) * 100.0));
                nameList.add(xcTj.getName());
                xcdksList.add(xcTj.getXcdks());
                wyXcdksList.add(xcTj.getXcdksWy());
                hyXcdksList.add(xcTj.getXcdksHy());
                wyXcdmjList.add(xcTj.getXcdkmjWy());
                hyXcdmjList.add(xcTj.getXcdkmjHy());
            }
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if ("qy".equals(type)) {
            dataMap.put("xzqWptbzsList", wptbzsList.toArray());
            dataMap.put("xzqWptbzmjList", wptbzmjList.toArray());
            dataMap.put("xzqNameList", nameList.toArray());
        } else if ("nd".equals(type)) {
            dataMap.put("ndWptbzsList", wptbzsList.toArray());
            dataMap.put("ndWptbzmjList", wptbzmjList.toArray());
            dataMap.put("ndNameList", nameList.toArray());
        }
        dataMap.put("hfzsList", hfzsList.toArray());
        dataMap.put("hfmjList", hfmjList.toArray());
        dataMap.put("wfzsList", wfzsList.toArray());
        dataMap.put("wfmjList", wfmjList.toArray());
        dataMap.put("xczcsList", xczcsList.toArray());
        dataMap.put("xczglsList", xczglsList.toArray());
        dataMap.put("xcfglList", xcfglList.toArray());
        dataMap.put("xcdksList", xcdksList.toArray());
        dataMap.put("xcdkmjList", xcdkmjList.toArray());
        dataMap.put("wyXcdksList", wyXcdksList.toArray());
        dataMap.put("hyXcdksList", hyXcdksList.toArray());
        dataMap.put("wyXcdmjList", wyXcdmjList.toArray());
        dataMap.put("hyXcdmjList", hyXcdmjList.toArray());
        return dataMap;
    }

    @GetMapping(value={"/getWfccajData"})
    public Map<String, Object> getWfccajData(@RequestParam(value="xzqdm") String xzqdm, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) {
        LeasWfTjResponse leasWfTjResponse = null;
        LeasWfTjRequest leasWfTjRequest = new LeasWfTjRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("xzqdm", xzqdm);
        leasWfTjRequest.setJsonParam(JSON.toJSONString(map));
        try {
            leasWfTjResponse = (LeasWfTjResponse)this.leasClient.execute((LeasRequest)leasWfTjRequest);
        }
        catch (ApiException e) {
            this.logger.error(e.getErrMsg());
        }
        HashMap<String, String> wfccMap = leasWfTjResponse.getRESULT();
        if (wfccMap == null) {
            wfccMap = new HashMap<String, String>();
            wfccMap.put("result", "\u6ca1\u6709\u6570\u636e\uff01");
        }
        return wfccMap;
    }

    @GetMapping(value={"/getXchwphjData"})
    public XcLjTj getXchwphjData(@RequestParam(value="xzqdm") String xzqdm, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) {
        LeasXchjResponse leasXchjResponse = null;
        LeasXchjRequest leasXchjRequest = new LeasXchjRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("xzqdm", xzqdm);
        leasXchjRequest.setJsonParam(JSON.toJSONString(map));
        try {
            leasXchjResponse = (LeasXchjResponse)this.leasClient.execute((LeasRequest)leasXchjRequest);
        }
        catch (ApiException e) {
            this.logger.error(e.getErrMsg());
        }
        return leasXchjResponse.getResult();
    }

    @RequestMapping(value={"/getWptbData"})
    public Map<String, Object> getWptbData(String year, String xzq) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("year", year);
        map.put("xzq", xzq);
        return this.zfxcService.getWptbData(map);
    }
}

