/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.zhgk.manage.web;

import cn.gtmap.gtc.zhgk.common.model.TableRequestList;
import cn.gtmap.gtc.zhgk.common.utils.publicUtils;
import cn.gtmap.gtc.zhgk.manage.service.OpreationService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="OperationController", tags={"\u8fd0\u7ef4\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"manage/v1"})
public class OperationController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    public OpreationService opreationService;

    @RequestMapping(value={"/getDataById"})
    public Map<String, Object> getDataById(String id, String tableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("tableName", tableName);
        return this.opreationService.getDataById(map);
    }

    @RequestMapping(value={"/insertNewData"})
    public String insertNewData(@RequestBody Map<String, Object> mapData, String tableName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        mapData.remove("tableName");
        String rq = mapData.get("RQ").toString();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateRq = sDateFormat.parse(rq);
        mapData.put("RQ", dateRq);
        mapData.put("CRSJ", new Date());
        List keyList = publicUtils.getListByMap(mapData, (boolean)true);
        List valueList = publicUtils.getListByMap(mapData, (boolean)false);
        map.put("keyList", keyList);
        map.put("valueList", valueList);
        map.put("tableName", tableName);
        return this.opreationService.insertNewData(map);
    }

    @RequestMapping(value={"/updataNewData"})
    public String updataNewData(@RequestBody Map<String, Object> mapData, String tableName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        mapData.remove("tableName");
        String rq = mapData.get("RQ").toString();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateRq = sDateFormat.parse(rq);
        mapData.put("RQ", dateRq);
        mapData.put("CRSJ", new Date());
        map.put("mapData", mapData);
        map.put("id", mapData.get("Id").toString());
        map.put("tableName", tableName);
        return this.opreationService.updataNewData(map);
    }

    @RequestMapping(value={"/deleteData"})
    public String deleteData(String id, String tableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("tableName", tableName);
        String result = this.opreationService.deleteData(map);
        return JSON.toJSONString((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveFile"})
    @HystrixCommand(commandProperties={@HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="3000000")})
    public String saveFile(@RequestParam(name="excel") File excel, String tableName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Serializable> param = new HashMap<String, Serializable>(12);
        ArrayList<Object> keyList = new ArrayList<Object>();
        ArrayList valueLists = new ArrayList();
        InputStream inputStream = null;
        int totalCol = 4;
        int failCount = 0;
        int successCount = 0;
        ArrayList errorList = new ArrayList();
        try {
            if (excel != null && excel.exists()) {
                CellStyle cellStyle;
                XSSFWorkbook workbook;
                inputStream = new FileInputStream(excel);
                if (excel.getName().endsWith("xlsx")) {
                    workbook = new XSSFWorkbook(inputStream);
                    XSSFDataFormat dataFormat = (XSSFDataFormat)workbook.createDataFormat();
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setDataFormat(dataFormat.getFormat("@"));
                } else {
                    POIFSFileSystem fs = new POIFSFileSystem(inputStream);
                    workbook = new HSSFWorkbook(fs);
                    HSSFDataFormat dataFormat = (HSSFDataFormat)workbook.createDataFormat();
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setDataFormat(dataFormat.getFormat("@"));
                }
                for (int numSheet = 0; numSheet < workbook.getNumberOfSheets(); ++numSheet) {
                    Sheet sheet = workbook.getSheetAt(numSheet);
                    int totalRow = sheet.getLastRowNum();
                    if (sheet == null) continue;
                    Row row = sheet.getRow(2);
                    for (int titleNum = 0; titleNum < row.getLastCellNum(); ++titleNum) {
                        keyList.add(publicUtils.handleExcleType((Cell)row.getCell(titleNum)));
                    }
                    keyList.add("Id");
                    keyList.add("CRSJ");
                    for (int rowNum = 3; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        Row rowData = sheet.getRow(rowNum);
                        if (rowData == null) continue;
                        for (int cellNum = 0; cellNum < rowData.getLastCellNum(); ++cellNum) {
                            arrayList.add(publicUtils.handleExcleType((Cell)rowData.getCell(cellNum)));
                        }
                        valueLists.add(arrayList);
                    }
                    for (List list : valueLists) {
                        String id = UUID.randomUUID().toString().replace("-", "").toUpperCase();
                        list.add(id);
                        list.add(new Date());
                        map.put("keyList", keyList);
                        map.put("valueList", list);
                        map.put("tableName", tableName);
                        String result = this.opreationService.insertNewData(map);
                        if (result.equals("success")) {
                            ++successCount;
                            continue;
                        }
                        ++failCount;
                    }
                }
                param.put("failCount", Integer.valueOf(failCount));
                param.put("successCount", Integer.valueOf(successCount));
                param.put("errorList", errorList);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return JSON.toJSONString(param);
    }

    @RequestMapping(value={"/getTableList"})
    public List getTableList() {
        HashMap map = new HashMap();
        List result = this.opreationService.getTableList(map);
        return result;
    }

    @RequestMapping(value={"/getTableData"})
    public TableRequestList getTableData(@RequestParam(name="page", required=false) int page, @RequestParam(name="limit", required=false) int limit, @RequestParam(name="params") String params) {
        ArrayList list = new ArrayList();
        IPage valueIpage = this.opreationService.getTableData(page, limit, params);
        List maps = valueIpage.getRecords();
        long counts = valueIpage.getTotal();
        return new TableRequestList(counts, maps);
    }

    @RequestMapping(value={"/getTableCols"})
    public List getTableCols(@RequestParam(value="tableName") String tableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tableName", tableName);
        List result = this.opreationService.getTableCols(map);
        return result;
    }

    @RequestMapping(value={"/getDataDetails"})
    public TableRequestList getDataDetails(@RequestParam(name="page", required=false) int page, @RequestParam(name="limit", required=false) int limit, @RequestParam(name="params") String params) {
        ArrayList list = new ArrayList();
        IPage valueIpage = this.opreationService.getDataDetails(page, limit, params);
        List maps = valueIpage.getRecords();
        long counts = valueIpage.getTotal();
        return new TableRequestList(counts, maps);
    }

    @RequestMapping(value={"/getMapServers"})
    public Map<String, Object> getMapServers(Model model, @RequestParam HashMap<String, Object> map) {
        Map result = this.opreationService.getMapServers(map);
        return result;
    }
}

