/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.zhgk.manage.web;

import cn.gtmap.api.ApiException;
import cn.gtmap.api.InsightClient;
import cn.gtmap.api.InsightRequest;
import cn.gtmap.api.camera.CameraCountTjRequest;
import cn.gtmap.api.camera.CameraCountTjResponse;
import cn.gtmap.api.camera.CameraTjRequest;
import cn.gtmap.api.camera.CameraTjResponse;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ZfjcController", tags={"\u6267\u6cd5\u76d1\u5bdf"})
@RestController
@RequestMapping(value={"manage/hyst"})
public class HystController {
    private Logger logger = LoggerFactory.getLogger(HystController.class);
    @Autowired
    private InsightClient insightClient;

    @GetMapping(value={"/getHysttjData"})
    public Map<String, Object> getHysttjData(@RequestParam(value="userId") String userId, @RequestParam(value="method") String method, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) {
        CameraTjResponse response = null;
        CameraTjRequest request = new CameraTjRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("method", method);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        request.setJsonParam(JSON.toJSONString(map));
        try {
            response = (CameraTjResponse)this.insightClient.execute((InsightRequest)request);
        }
        catch (ApiException e) {
            this.logger.error(e.getErrMsg());
        }
        List cameraTjList = response.getResult();
        ArrayList<String> groupNameList = new ArrayList<String>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            Date start = new SimpleDateFormat("yyyy-MM-dd").parse(startDate);
            Date end = new SimpleDateFormat("yyyy-MM-dd").parse(endDate);
            Long day = (end.getTime() - start.getTime()) / 86400000L;
            if ("ttjktj".equals(method)) {
                ArrayList<String> countsList = new ArrayList<String>();
                ArrayList<String> useNumberList = new ArrayList<String>();
                int ttzs = 0;
                Double sypc = 0.0;
                if (!CollectionUtils.isEmpty((Collection)cameraTjList)) {
                    for (HashMap hashMap : cameraTjList) {
                        countsList.add(MapUtils.getString((Map)hashMap, (Object)"counts"));
                        useNumberList.add(MapUtils.getString((Map)hashMap, (Object)"useNumber"));
                        groupNameList.add(MapUtils.getString((Map)hashMap, (Object)"groupName"));
                        ttzs += Integer.parseInt(MapUtils.getString((Map)hashMap, (Object)"counts"));
                        sypc = sypc + new BigDecimal(Double.valueOf(MapUtils.getString((Map)hashMap, (Object)"useNumber"))).setScale(2, 4).doubleValue();
                    }
                }
                Double syqd = new BigDecimal((long)ttzs * day == 0L ? 0.0 : sypc / (double)((long)ttzs * day)).setScale(4, 4).doubleValue();
                dataMap.put("countsList", countsList.toArray());
                dataMap.put("useNumberList", useNumberList.toArray());
                dataMap.put("ttzs", ttzs);
                dataMap.put("sypc", sypc);
                dataMap.put("syqd", syqd);
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        if ("zxlxtj".equals(method)) {
            ArrayList<String> offlineCountsList = new ArrayList<String>();
            ArrayList onlineCountsList = new ArrayList();
            int zxs = 0;
            int lxs = 0;
            if (!CollectionUtils.isEmpty((Collection)cameraTjList)) {
                for (HashMap hashMap : cameraTjList) {
                    groupNameList.add(MapUtils.getString((Map)hashMap, (Object)"groupName"));
                    offlineCountsList.add(MapUtils.getString((Map)hashMap, (Object)"offlineCounts"));
                    onlineCountsList.add(MapUtils.getString((Map)hashMap, (Object)"onlineCounts"));
                    zxs += Integer.parseInt(MapUtils.getString((Map)hashMap, (Object)"onlineCounts"));
                    lxs += Integer.parseInt(MapUtils.getString((Map)hashMap, (Object)"offlineCounts"));
                }
            }
            dataMap.put("offlineCountsList", offlineCountsList.toArray());
            dataMap.put("onlineCountsList", onlineCountsList.toArray());
            dataMap.put("zxs", zxs);
            dataMap.put("lxs", lxs);
        }
        if ("rmtj".equals(method)) {
            ArrayList<String> useNumberList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)cameraTjList)) {
                for (HashMap hashMap : cameraTjList) {
                    groupNameList.add(MapUtils.getString((Map)hashMap, (Object)"groupName"));
                    useNumberList.add(MapUtils.getString((Map)hashMap, (Object)"useNumber"));
                }
            }
            dataMap.put("useNumberList", useNumberList.toArray());
        }
        if ("sctj".equals(method)) {
            ArrayList<String> useHoursList = new ArrayList<String>();
            Double syzsc = 0.0;
            if (!CollectionUtils.isEmpty((Collection)cameraTjList)) {
                for (HashMap hashMap : cameraTjList) {
                    groupNameList.add(MapUtils.getString((Map)hashMap, (Object)"groupName"));
                    useHoursList.add(MapUtils.getString((Map)hashMap, (Object)"useHours"));
                    syzsc = syzsc + new BigDecimal(Double.valueOf(MapUtils.getString((Map)hashMap, (Object)"useHours"))).setScale(2, 5).doubleValue();
                }
            }
            dataMap.put("useHoursList", useHoursList.toArray());
            dataMap.put("syzsc", syzsc);
        }
        dataMap.put("groupNameList", groupNameList.toArray());
        return dataMap;
    }

    @GetMapping(value={"/getCountTjData"})
    public Map<String, Object> getHysttjData(@RequestParam(value="userId") String userId) {
        CameraCountTjResponse response = null;
        CameraCountTjRequest request = new CameraCountTjRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        request.setJsonParam(JSON.toJSONString(map));
        try {
            response = (CameraCountTjResponse)this.insightClient.execute((InsightRequest)request);
        }
        catch (ApiException e) {
            this.logger.error(e.getErrMsg());
        }
        HashMap hashMap = response.getResult();
        String counts = "";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            if (hashMap != null) {
                counts = MapUtils.getString((Map)hashMap, (Object)"counts");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        dataMap.put("counts", counts);
        return dataMap;
    }
}

