/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.zhgk.manage.service.impl;

import cn.gtmap.gtc.zhgk.manage.service.BaseService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class BaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T>
implements BaseService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);

    public T getObj(Wrapper<T> queryWrapper) {
        return (T)SqlHelper.getObject((List)this.listObjs(queryWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E selectOne(String statement, Object parameter) {
        try (SqlSession sqlSession = super.sqlSessionBatch();){
            Object object = sqlSession.selectOne(statement, parameter);
            return (E)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> selectList(String statement, Object parameter) {
        try (SqlSession sqlSession = super.sqlSessionBatch();){
            List list = sqlSession.selectList(statement, parameter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String statement, Object parameter) {
        try (SqlSession sqlSession = null;){
            sqlSession = SqlHelper.FACTORY.openSession();
            int result = sqlSession.insert(statement, parameter);
            sqlSession.commit();
            boolean bl = this.retBool(Integer.valueOf(result));
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String statement, Object parameter) {
        try (SqlSession sqlSession = null;){
            sqlSession = SqlHelper.FACTORY.openSession();
            int result = sqlSession.update(statement, parameter);
            sqlSession.commit();
            boolean bl = this.retBool(Integer.valueOf(result));
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String statement, Object parameter) {
        try (SqlSession sqlSession = null;){
            sqlSession = SqlHelper.FACTORY.openSession();
            int result = sqlSession.delete(statement, parameter);
            sqlSession.commit();
            boolean bl = this.retBool(Integer.valueOf(result));
            return bl;
        }
        return false;
    }

    public T findByForeignId(String key, Object value) {
        List list = this.findListByForeignId(key, value);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (T)list.get(0);
        }
        return null;
    }

    public T findByForeignId(Map<String, Object> map) {
        if (map != null) {
            QueryWrapper wrapper = new QueryWrapper();
            map.forEach((k, v) -> {
                if (StringUtils.isNotEmpty((CharSequence)k) && v != null && !"".equals(v.toString())) {
                    wrapper.eq(k, v);
                }
            });
            List list = this.list((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                return (T)list.get(0);
            }
        }
        return null;
    }

    public <T> List<T> findListByForeignId(String key, Object value) {
        if (!StringUtils.isEmpty((CharSequence)key) && value != null && !"".equals(value.toString())) {
            Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)key, value);
            return this.list(wrapper);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByForeignKey(String key, Object value) {
        if (!StringUtils.isEmpty((CharSequence)key) && value != null && !"".equals(value.toString())) {
            return this.remove((Wrapper)new QueryWrapper().eq((Object)key, value));
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T entity) {
        Class<?> cls = entity.getClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        if (null != tableInfo && StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            Object idVal = ReflectionKit.getMethodValue(cls, entity, (String)tableInfo.getKeyProperty());
            updateWrapper.eq((Object)tableInfo.getKeyColumn(), idVal);
            tableInfo.getFieldList().forEach(tableFieldInfo -> {
                Object fieldVal = ReflectionKit.getMethodValue((Class)cls, (Object)entity, (String)tableFieldInfo.getProperty());
                updateWrapper.set(tableFieldInfo.getColumn(), fieldVal);
            });
            try {
                return this.retBool(Integer.valueOf(this.baseMapper.update(entity.getClass().newInstance(), (Wrapper)updateWrapper)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (!CollectionUtils.isEmpty(entityList)) {
            entityList.forEach(entity -> this.saveOrUpdate(entity));
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        if (!CollectionUtils.isEmpty(entityList)) {
            entityList.forEach(entity -> this.updateById(entity));
            return true;
        }
        return false;
    }
}

