/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.bpmn.impl.handler;

import java.util.List;
import org.apache.http.client.HttpClient;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.delegate.invocation.DelegateInvocation;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.HttpRequest;
import org.flowable.http.HttpResponse;
import org.flowable.http.bpmn.impl.delegate.HttpRequestHandlerInvocation;
import org.flowable.http.bpmn.impl.delegate.HttpResponseHandlerInvocation;
import org.flowable.http.delegate.HttpRequestHandler;
import org.flowable.http.delegate.HttpResponseHandler;

public class DelegateExpressionHttpHandler
implements HttpRequestHandler,
HttpResponseHandler {
    private static final long serialVersionUID = 1L;
    protected Expression expression;
    protected final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionHttpHandler(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void handleHttpRequest(VariableContainer execution, HttpRequest httpRequest, HttpClient client) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression((Expression)this.expression, (VariableContainer)execution, this.fieldDeclarations);
        if (!(delegate instanceof HttpRequestHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpRequestHandler.class);
        }
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation((DelegateInvocation)new HttpRequestHandlerInvocation((HttpRequestHandler)delegate, execution, httpRequest, client));
    }

    @Override
    public void handleHttpResponse(VariableContainer execution, HttpResponse httpResponse) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression((Expression)this.expression, (VariableContainer)execution, this.fieldDeclarations);
        if (!(delegate instanceof HttpResponseHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpResponseHandler.class);
        }
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation((DelegateInvocation)new HttpResponseHandlerInvocation((HttpResponseHandler)delegate, execution, httpResponse));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

