/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.bpmn.impl;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowableHttpRequestHandler;
import org.flowable.bpmn.model.FlowableHttpResponseHandler;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.cfg.HttpClientConfig;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.el.FixedValue;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.ExpressionUtils;
import org.flowable.http.HttpActivityExecutor;
import org.flowable.http.HttpRequest;
import org.flowable.http.bpmn.impl.ProcessErrorPropagator;
import org.flowable.http.bpmn.impl.handler.ClassDelegateHttpHandler;
import org.flowable.http.bpmn.impl.handler.DelegateExpressionHttpHandler;
import org.flowable.http.delegate.HttpRequestHandler;
import org.flowable.http.delegate.HttpResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpActivityBehaviorImpl
extends AbstractBpmnActivityBehavior {
    public static final String HTTP_TASK_REQUEST_FIELD_INVALID = "request fields are invalid";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpActivityBehaviorImpl.class);
    protected Expression requestMethod;
    protected Expression requestUrl;
    protected Expression requestHeaders;
    protected Expression requestBody;
    protected Expression requestTimeout;
    protected Expression disallowRedirects;
    protected Expression failStatusCodes;
    protected Expression handleStatusCodes;
    protected Expression ignoreException;
    protected Expression saveRequestVariables;
    protected Expression saveResponseParameters;
    protected Expression responseVariableName;
    protected Expression saveResponseParametersTransient;
    protected Expression saveResponseVariableAsJson;
    protected Expression resultVariablePrefix;
    protected List<MapExceptionEntry> mapExceptions;
    protected HttpServiceTask httpServiceTask;
    protected HttpActivityExecutor httpActivityExecutor;

    public HttpActivityBehaviorImpl() {
        HttpClientConfig config = CommandContextUtil.getProcessEngineConfiguration().getHttpClientConfig();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (config.isDisableCertVerify()) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                }));
            }
            catch (Exception e) {
                LOGGER.error("Could not configure HTTP client SSL self signed strategy", (Throwable)e);
            }
        }
        int retryCount = 0;
        if (config.getRequestRetryLimit() > 0) {
            retryCount = config.getRequestRetryLimit();
        }
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount, false));
        this.httpActivityExecutor = new HttpActivityExecutor(httpClientBuilder, new ProcessErrorPropagator(), CommandContextUtil.getProcessEngineConfiguration().getObjectMapper());
    }

    public void execute(DelegateExecution execution) {
        HttpRequest request = new HttpRequest();
        try {
            request.setMethod(ExpressionUtils.getStringFromField(this.requestMethod, (VariableContainer)execution));
            request.setUrl(ExpressionUtils.getStringFromField(this.requestUrl, (VariableContainer)execution));
            request.setHeaders(ExpressionUtils.getStringFromField(this.requestHeaders, (VariableContainer)execution));
            request.setBody(ExpressionUtils.getStringFromField(this.requestBody, (VariableContainer)execution));
            request.setTimeout(ExpressionUtils.getIntFromField(this.requestTimeout, (VariableContainer)execution));
            request.setNoRedirects(ExpressionUtils.getBooleanFromField(this.disallowRedirects, (VariableContainer)execution));
            request.setIgnoreErrors(ExpressionUtils.getBooleanFromField(this.ignoreException, (VariableContainer)execution));
            request.setSaveRequest(ExpressionUtils.getBooleanFromField(this.saveRequestVariables, (VariableContainer)execution));
            request.setSaveResponse(ExpressionUtils.getBooleanFromField(this.saveResponseParameters, (VariableContainer)execution));
            request.setSaveResponseTransient(ExpressionUtils.getBooleanFromField(this.saveResponseParametersTransient, (VariableContainer)execution));
            request.setSaveResponseAsJson(ExpressionUtils.getBooleanFromField(this.saveResponseVariableAsJson, (VariableContainer)execution));
            request.setPrefix(ExpressionUtils.getStringFromField(this.resultVariablePrefix, (VariableContainer)execution));
            String failCodes = ExpressionUtils.getStringFromField(this.failStatusCodes, (VariableContainer)execution);
            String handleCodes = ExpressionUtils.getStringFromField(this.handleStatusCodes, (VariableContainer)execution);
            if (failCodes != null) {
                request.setFailCodes(ExpressionUtils.getStringSetFromField(failCodes));
            }
            if (handleCodes != null) {
                request.setHandleCodes(ExpressionUtils.getStringSetFromField(handleCodes));
            }
            if (request.getPrefix() == null) {
                request.setPrefix(execution.getCurrentFlowElement().getId());
            }
            if (request.isSaveRequest()) {
                execution.setVariable(request.getPrefix() + "RequestMethod", (Object)request.getMethod());
                execution.setVariable(request.getPrefix() + "RequestUrl", (Object)request.getUrl());
                execution.setVariable(request.getPrefix() + "RequestHeaders", (Object)request.getHeaders());
                execution.setVariable(request.getPrefix() + "RequestBody", (Object)request.getBody());
                execution.setVariable(request.getPrefix() + "RequestTimeout", (Object)request.getTimeout());
                execution.setVariable(request.getPrefix() + "DisallowRedirects", (Object)request.isNoRedirects());
                execution.setVariable(request.getPrefix() + "FailStatusCodes", (Object)failCodes);
                execution.setVariable(request.getPrefix() + "HandleStatusCodes", (Object)handleCodes);
                execution.setVariable(request.getPrefix() + "IgnoreException", (Object)request.isIgnoreErrors());
                execution.setVariable(request.getPrefix() + "SaveRequestVariables", (Object)request.isSaveRequest());
                execution.setVariable(request.getPrefix() + "SaveResponseParameters", (Object)request.isSaveResponse());
            }
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)e;
            }
            throw new FlowableException("request fields are invalid in execution " + execution.getId(), (Throwable)e);
        }
        this.httpActivityExecutor.validate(request);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        HttpClientConfig httpClientConfig = CommandContextUtil.getProcessEngineConfiguration().getHttpClientConfig();
        this.httpActivityExecutor.execute(request, (VariableContainer)execution, execution.getId(), this.createHttpRequestHandler(this.httpServiceTask.getHttpRequestHandler(), processEngineConfiguration), this.createHttpResponseHandler(this.httpServiceTask.getHttpResponseHandler(), processEngineConfiguration), ExpressionUtils.getStringFromField(this.responseVariableName, (VariableContainer)execution), this.mapExceptions, httpClientConfig.getSocketTimeout(), httpClientConfig.getConnectTimeout(), httpClientConfig.getConnectionRequestTimeout());
        this.leave(execution);
    }

    protected HttpRequestHandler createHttpRequestHandler(FlowableHttpRequestHandler handler, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HttpResponseHandler requestHandler = null;
        if (handler != null) {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new ClassDelegateHttpHandler(handler.getImplementation(), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new DelegateExpressionHttpHandler(processEngineConfiguration.getExpressionManager().createExpression(handler.getImplementation()), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            }
        }
        return requestHandler;
    }

    protected HttpResponseHandler createHttpResponseHandler(FlowableHttpResponseHandler handler, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HttpResponseHandler responseHandler = null;
        if (handler != null) {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new ClassDelegateHttpHandler(handler.getImplementation(), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new DelegateExpressionHttpHandler(processEngineConfiguration.getExpressionManager().createExpression(handler.getImplementation()), this.createFieldDeclarations(handler.getFieldExtensions(), processEngineConfiguration));
            }
        }
        return responseHandler;
    }

    protected List<FieldDeclaration> createFieldDeclarations(List<FieldExtension> fieldList, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        for (FieldExtension fieldExtension : fieldList) {
            FieldDeclaration fieldDeclaration = StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression()) ? new FieldDeclaration(fieldExtension.getFieldName(), Expression.class.getName(), (Object)processEngineConfiguration.getExpressionManager().createExpression(fieldExtension.getExpression())) : new FieldDeclaration(fieldExtension.getFieldName(), Expression.class.getName(), (Object)new FixedValue((Object)fieldExtension.getStringValue()));
            fieldDeclarations.add(fieldDeclaration);
        }
        return fieldDeclarations;
    }

    public void setServiceTask(ServiceTask serviceTask) {
        this.httpServiceTask = (HttpServiceTask)serviceTask;
    }
}

