package cn.gtmap.gtc.workflow.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

/**
 * Resource utils
 *
 * @author monarchCheng
 * @create 2017-11-09 18:21
 **/
public class BeanUtil {

    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    /**
     * copy Bean
     *
     * @param source
     * @param target
     */
    public static void copyBean(Object source, Object target, String... ignores) {
        BeanUtils.copyProperties(source, target, ignores);
    }

    /**
     * copy Bean List
     *
     * @param iterable
     * @param targetClazz
     * @param <T>
     * @return
     */
    public static <T> List<T> copyBeanList(Iterable iterable, Class<T> targetClazz) {
        List<T> newList = new ArrayList<>();
        for (Object o : iterable) {
            try {
                T t = targetClazz.newInstance();
                BeanUtils.copyProperties(o, t);
                newList.add(t);
            } catch (Exception e) {
                logger.info(e.getMessage(),e);
            }
        }
        return newList;
    }


    /**
     * copy bean page
     *
     * @param page
     * @param pageable
     * @param targetClazz
     * @param <T>
     * @return
     */
    public static <T> Page<T> copyBeanPage(Page page, Pageable pageable, Class<T> targetClazz) {
        List<T> newList = copyBeanList(page, targetClazz);
        return new PageImpl(newList, pageable, page.getTotalElements());
    }


    /**
     * get ids
     *
     * @param list
     * @param clazz
     * @param methodName
     * @param <T>
     * @return
     */
    public static <T> List<String> getIds(List<T> list, Class clazz, String methodName) {
        List<String> ids = new ArrayList<>(list.size());
        try {
            Method m = clazz.getMethod(methodName);
            for (T t : list) {
                String id = (String) m.invoke(t);
                ids.add(id);
            }
        } catch (Exception e) {
            logger.info(e.getMessage(),e);
        }
        return ids;
    }

    /**
     * 获取所有的方法，包括private、public、protect，和从其他类继承来的
     */
    private static List<Method> getAllMethod(Object obj) {
        List<Method> methods = new ArrayList<>();
        Class<?> clazz = obj.getClass();
        while (!clazz.isAssignableFrom(Object.class)) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    /**
     * bean转Map
     *
     * @param obj
     * @return
     */
    public static Map<String, Object> convertMap(Object obj) {
        List<Method> methods = getAllMethod(obj);
        Map<String, Object> map = new HashMap<>(16);

        for (Method m : methods) {
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                try {
                    map.put(propertyName, m.invoke(obj));
                } catch (IllegalAccessException e) {
                    logger.info(e.getMessage(),e);
                } catch (IllegalArgumentException e) {
                    logger.info(e.getMessage(),e);
                } catch (InvocationTargetException e) {
                    logger.info(e.getMessage(),e);
                }
            }
        }
        return map;
    }

    public  void transMapToBean(Map<String, Object> map, Object obj) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();

            for (PropertyDescriptor property : propertyDescriptors) {
                String key = property.getName();

                if (map.containsKey(key)) {
                    Object value = map.get(key);
                    // 得到property对应的setter方法
                    Method setter = property.getWriteMethod();
                    setter.invoke(obj, value);
                }
            }
        } catch (Exception e) {
            logger.info("transMap2Bean Error " + e);
        }
        return;
    }

}
