package cn.gtmap.gtc.workflow.helper;

import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.utils.DateUtils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

/**
 * 工作日计算辅助类
 * <p>
 * 与{@link StrictWorkdayHelper}不同的是该类在按天计算超期时更加宽松，时间会延长到超期那天的23:59:59
 *
 * @author Fjj
 * @date 2018/8/20
 */
public class SimpleWorkdayHelper extends AbstractWorkdayHelper {

    private static final String LAST_TIME = "23:59:59";

    public SimpleWorkdayHelper(List<WorkDay> list) {
        init(list);
    }

    /**
     * 工作日计算，加天数（排除节假日和休息日）,用于计算到期时间
     * <p>
     * 到期时间为指定天数后的23:59:59
     *
     * @param calendar 起算时间
     * @param day      相加天数，大于0
     * @return Calendar 返回相加day天，并且排除节假日和周末后的日期
     */
    @Override
    public Calendar addDateByWorkDay(Calendar calendar, int day) throws ParseException {
        WorkDayTimeType workDayTimeType = checkWorkTimeType(calendar);
        Calendar dueCalendar = null;
        if (workDayTimeType == WorkDayTimeType.NOT_WORKDAY || workDayTimeType == WorkDayTimeType.BEFORE_MORNING_STRAT
                || workDayTimeType == WorkDayTimeType.AFTER_AFTERNOON_END) {
            //如果当天不是工作日或在早晨工作时间开始前，需要先找到最近的开始工作时间
            Calendar realStartTime = getNearWorkTime(calendar, workDayTimeType);
            String realStartDateStr = dateFormat.format(realStartTime.getTime());
            int indexInWorkDay = indexMap.get(realStartDateStr) + (day - 1);
            WorkDay workDay = workDayList.get(indexInWorkDay);
            dueCalendar = DateUtils.toCalendar(workDay.getWorkDay() + A_BLANK + LAST_TIME, DateUtils.DateFormatType.DATETIME);
        } else {
            String dateStr = dateFormat.format(calendar.getTime());
            int indexInWorkDay = indexMap.get(dateStr);
            int dueIndexInWorkDay = indexInWorkDay + day;
            WorkDay dueWorkDay = workDayList.get(dueIndexInWorkDay);
            dueCalendar = DateUtils.toCalendar(dueWorkDay.getWorkDay() + A_BLANK + LAST_TIME, DateUtils.DateFormatType.DATETIME);
        }
        return dueCalendar;
    }

}
