package cn.gtmap.gtc.workflow.enums.variable;

/**
 * @author <a href="mailto:xuchao@gtmap.cn">xuchao</a>
 * @version 1.0.2019/3/1
 * @description 表单属性key配置
 */
public enum CustomActivityProperty {
    BACK_COMPENSATION_URL("BACK_COMPENSATION_URL","补偿服务地址"),
    BACK_COMPENSATION_URL_METHOD("BACK_COMPENSATION_URL_METHOD","补偿方法类型"),
    BACK_COMPENSATION_URL_REQUEYSTBODY("BACK_COMPENSATION_URL_REQUEYSTBODY","补偿请求体"),
    IS_SIGN("IS_SIGN","是否签名"),
    SIGN_KEY("SIGN_KEY","签名Key"),
    IS_BACK("IS_BACK","是否允许回退"),
    SAME_PEOPLE_ACTIVITY_ID("SAME_PEOPLE_ACTIVITY_ID","相同办理节点"),
    DNEXT_DISPATCH_STATEGY("DNEXT_DISPATCH_STATEGY","下节点派件策略"),

    BEFORE_FORWARD_URL("BEFORE_FORWARD_URL","转发前验证地址"),
    BEFORE_FORWARD_URL_METHOD("BEFORE_FORWARD_URL_METHOD","转发前方法类型"),
    BEFORE_FORWARD_URL_REQUEYSTBODY("BEFORE_FORWARD_URL_REQUEYSTBODY","转发前验证请求体"),

    BEFORE_DELETE_URL("BEFORE_DELETE_URL","删除前验证地址"),
    BEFORE_DELETE_URL_METHOD("BEFORE_DELETE_URL_METHOD","删除前方法类型"),
    BEFORE_DELETE_URL_REQUEYSTBODY("BEFORE_DELETE_URL_REQUEYSTBODY","删除前验证请求体"),
    DEFAULT_RECEIVER("DEFAULT_RECEIVER","默认的受理人"),
    MSG_TEMPLATE("MSG_TEMPLATE","短信模板"),
    //传阅节点配置
    IS_CIRCULATE("IS_CIRCULATE","是否传阅节点"),
    //协办节点配置
    IS_JOIN_TASK("IS_JOIN_TASK","是否协办节点"),
    //传阅主节点的配置
    IS_CIRCULATE_TO_UNDO("IS_CIRCULATE_TO_UNDO","是否传阅转待办"),//结束所有子的传阅任务
    IS_CIRCULATE_AUTO("IS_CIRCULATE_AUTO","传阅节点是否自动转发"),    //默认自动转发
    CIRCULATE_TRANSMIT_ACTITYID("CIRCULATE_TRANSMIT_ACTITYID","传阅节点的默认转发节点ID"),
    CIRCULATE_TRANSMIT_USERNAME("CIRCULATE_TRANSMIT_USERNAME","传阅节点的默认转发人员"),
    //自动启动子流程配置
    IS_AUTO_CREATE_TASK("IS_AUTO_CREATE_TASK","是否自动启动新流程"),
    AUTO_CREATE_URL("AUTO_CREATE_URL","自动启动新流程回调地址"),
    AUTO_CREATE_URL_METHOD("AUTO_CREATE_URL_METHOD","自动启动新流程http回调方法"),
    AUTO_CREATE_URL_REQUEYSTBODY("AUTO_CREATE_URL_REQUEYSTBODY","自动启动新流程回调请求体")
    ;

    private String value;
    private String label;

    private CustomActivityProperty(String value, String label){
        this.value = value;
        this.label = label;
    }

    public static CustomActivityProperty valueOf(int value) {
        for (CustomActivityProperty customActivityKey : values()) {
            if (customActivityKey.getValue().equals(value)) {
                return customActivityKey;
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }
}
