package cn.gtmap.gtc.workflow.enums.task;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/1/28
 * @description
 */
public enum TaskNodeType {

    /*
     * 启动节点
     * */
    START_EVENT("StartEvent"),

    /*
     * 人工节点
     * */
    USER_TASK("UserTask"),

    /*
     * 传阅节点
     * */
    READ_TASK("Read_Task"),

    /*
     * 协办节点
     * */
    HELP_TASK("Help_Task"),

    /*
     * 主传阅节点有子任务未完成
     * */
    SUB_READ_TASK_UNCOMPLETE("Sub_Read_Task_Uncomplete"),

    /*
     * 主协办节点有子任务未完成
     * */
    SUB_HELP_TASK_UNCOMPLETE("Sub_Help_Task_Uncomplete"),

    /*
    * 单实例
    * */
    ACTIVITY_BEHAVIOR("UserTaskActivityBehavior"),

    /*
     * 并行多实例
     * */
    PARALLEL_BEHAVIOR("ParallelMultiInstanceBehavior"),

    /*
    * 串行多实例
    * */
    SEQUENTIAL_BEHAVIOR("SequentialMultiInstanceBehavior"),

    /*
     * Http 服务节点
     * */
    HTTP_SERVICE_TASK("HttpServiceTask"),

    /*
     * 并行网关
     * */
    PARALLEL_GATEWAY("ParallelGateway"),

    /*
     * 独占网关
     * */
    EXCLUSIVE_GATEWAY("ExclusiveGateway"),

    /*
     * 包含网关
     * */
    INCLUSIVE_GATEWAY("InclusiveGateway"),

    /*
     * 事件网关
     * */
    EVENT_GATEWAY("EventGateway"),

    /*
     * 子流程
     * */
    SUB_PROCESS("SubProcess"),

    /*
     * 调用活动
     * */
    CALL_ACTIVITY("CallActivity"),


    /*
     * 流程线
     * */
    SEQUENCE_FLOW("SequenceFlow"),

    /*
     * 结束节点
     * */
    END_EVENT("EndEvent"),


    /*
     * 未知节点
     * */
    UNKNOWN("Unknown");

    private final String value;

    TaskNodeType(String v){
        value = v;
    }

    public String value() {
        return value;
    }
}
