package cn.gtmap.gtc.workflow.enums.statistics;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/13
 * @description
 */
public class StatisticsRabbitEnum {

    public enum ExchangeName {
        WORKFLOW_DIRECT_STATISTICS("workflow.direct.statistics", "工作流统计");
        private String name;
        private String remark;

        ExchangeName(String name, String remark) {
            this.name = name;
            this.remark = remark;
        }

        public String getRemark() {
            return remark;
        }

        public String getName() {
            return name;
        }
    }

    public enum QueueName {
        PROCESS_QUEUE("process.statistics.queue", "process", "流程实例队列"),
        TASK_QUEUE("task.statistics.queue", "task", "任务队列");

        private String name;
        private String routingKey;
        private String remark;

        QueueName(String name, String routingKey, String remark) {
            this.name = name;
            this.routingKey = routingKey;
            this.remark = remark;
        }

        public String getName() {
            return name;
        }

        public String getRoutingKey() {
            return routingKey;
        }

        public String getRemark() {
            return remark;
        }
    }

}
