package cn.gtmap.gtc.workflow.enums.manage;

/**
 * @Auther: zhoukang
 * @Date: 2019/12/25 09:29
 * @Description: 任务的类型
 */
public enum TaskType {

    COMMON_TASK(0, "普通"), READ_TASK(1,"阅办"),  HELP_TASK(2, "协办");

    private Integer value;

    private String remark;

    public Integer getValue() {
        return value;
    }

    public String getRemark() {
        return remark;
    }

    TaskType(int value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public static String getTaskTypeName(Integer status){
        if (status == null) {
            return null;
        }
        switch (status){
            case 0:
                return "普通";
            case 1:
                return "阅办";
            case 2:
                return "协办";
        }
        return null;
    }
}
