package cn.gtmap.gtc.workflow.domain.manage;

import cn.gtmap.gtc.workflow.utils.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: zhoukang
 * @Date: 2019/9/3 17:13
 * @Description: 任务日志，便于展示流程的任务转发详细
 */
public class TaskLogDto implements Comparator<TaskLogDto> {

    private String taskId;                      //任务名id

    private String activityName;                //活动节点名称

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date startTime;                   //任务开始时间

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date endTime;                     //任务结束时间

    private Integer days;                       //办理天数

    private String assignee;                    //任务办理人

    private String  lastActivityName;           //上个节点的名称

    private String lastActivityUsers;           //上个节点的办理人员（包含合并节点）

    private Map<String, String> comments;         //办理意见
    /**
     * 1：退回任务 2：被退回任务
     */
    private Integer backStatus;

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public String getAssignee() {
        return assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getLastActivityName() {
        return lastActivityName;
    }

    public void setLastActivityName(String lastActivityName) {
        this.lastActivityName = lastActivityName;
    }

    public String getLastActivityUsers() {
        return lastActivityUsers;
    }

    public void setLastActivityUsers(String lastActivityUsers) {
        this.lastActivityUsers = lastActivityUsers;
    }

    public Map<String, String> getComments() {
        return comments;
    }

    public void setComments(Map<String, String> comments) {
        this.comments = comments;
    }

    public Integer getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(Integer backStatus) {
        this.backStatus = backStatus;
    }

    @Override
    public int compare(TaskLogDto o1, TaskLogDto o2) {
        if(DateUtils.getTimeDifferenceInMinutesByDate(o1.getStartTime(),o2.getStartTime())>0){
            return 1;
        }else{
            return -1;
        }
    }
}
