package cn.gtmap.gtc.workflow.domain.manage;

import cn.gtmap.gtc.workflow.utils.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @Auther: zhoukang
 * @Date: 2019/9/2 16:34
 * @Description: 任务节点的展示
 */
public class ActivityNodeDto implements Comparator<ActivityNodeDto> {

    private String activityId;             //活动节点Id

    private String activityName;        //活动节点名称

    private Integer activityStatus;      //活动节点状态（0：待办 1：办结 2:退回）

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date startTime;           //活动节点开始时间（合并任务取最老时间）

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date endTime;             //活动节点开始时间（合并任务取最新时间）

    private Integer days;               //天数

    private List<String> unDoneUsers;    //待办的人员名称列表

    private List<String> backUsers;     //退回的人员名称列表

    private List<String> doneUsers;     //已办的人员名称列表

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public List<String> getUnDoneUsers() {
        return unDoneUsers;
    }

    public void setUnDoneUsers(List<String> unDoneUsers) {
        this.unDoneUsers = unDoneUsers;
    }

    public List<String> getDoneUsers() {
        return doneUsers;
    }

    public void setDoneUsers(List<String> doneUsers) {
        this.doneUsers = doneUsers;
    }

    public List<String> getBackUsers() {
        return backUsers;
    }

    public void setBackUsers(List<String> backUsers) {
        this.backUsers = backUsers;
    }

    @Override
    public int compare(ActivityNodeDto o1, ActivityNodeDto o2) {
        if(DateContrast(o1.getStartTime(),o2.getStartTime())>0){
            return 1;
        }else{
            return -1;
        }
    }
    private int DateContrast(Date date1,Date date2){
        if(null ==date1 || null ==date2){
            return 0;
        }
        return (int) (date1.getTime() - date2.getTime());
    }
}
