package cn.gtmap.gtc.workflow.domain.common;

import java.io.Serializable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/4/25
 * @description
 */

public class HttpEvent implements Serializable {

    private String url;

    private String model = "expression";

    private String method = "GET";

    private String exception = "EXCEPTION"; //NONE

    private String body = "";

    private String appName;

    public String getUrl() {
        return url;
    }

    public HttpEvent setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getModel() {
        return model;
    }

    public HttpEvent setModel(String model) {
        this.model = model;
        return this;
    }

    public String getMethod() {
        return method;
    }

    public HttpEvent setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getException() {
        return exception;
    }

    public HttpEvent setException(String exception) {
        this.exception = exception;
        return this;
    }

    public String getBody() {
        return body;
    }

    public HttpEvent setBody(String body) {
        this.body = body;
        return this;
    }

    public String getAppName() {
        return appName;
    }

    public HttpEvent setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public String toString() {
        return "HttpEvent{" +
                "url='" + url + '\'' +
                ", model='" + model + '\'' +
                ", method='" + method + '\'' +
                ", exception='" + exception + '\'' +
                ", body='" + body + '\'' +
                ", appName='" + appName + '\'' +
                '}';
    }
}
