package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.common.ProcessOptResultDto;
import cn.gtmap.gtc.workflow.domain.manage.BackTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.ForwardTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yuxinwang@gtmap.cn">yxw</a>
 * @version 1.0, 2018/7/11
 * @description 转发活动
 */

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface TaskHandleClient {

    /**
     * @param taskId
     * @return
     * @description 删除任务
     */
    @DeleteMapping(value = "/task-handel/{taskId}")
    boolean deleteTask(@PathVariable("taskId") String taskId);

    /**
     * @param processInstanceId 流程实例ID
     * @return
     * @description 根据流程实例id删除流程
     */
    @DeleteMapping(value = "/task-handel/process/{processInstanceId}")
    boolean deleteProcess(@PathVariable("processInstanceId") String processInstanceId);

    /**
     * 流程实例关闭(强制结束)
     * @param taskId
     */
    @PostMapping("/task-handel/{taskId}/finish")
    boolean processEndOfMandatory(@PathVariable("taskId") String taskId);

    /**
     * 流程实例废弃
     *
     * @param processInstanceId
     * @param deleteReason
     */
    @PostMapping("/task-handel/{processInstanceId}/task-discard")
    boolean taskAbandoned(@PathVariable("processInstanceId") String processInstanceId,
                                 @RequestParam(value = "deleteReason", required = false) String deleteReason);

    /**
     * 任务挂起
     *
     * @param processInstanceId
     */
    @PostMapping("/task-handel/{processInstanceId}/task-suspension")
    boolean taskHang(@PathVariable("processInstanceId") String processInstanceId,
                             @RequestParam(value = "reason", required = false) String reason);

    /**
     * 任务激活
     *
     * @param processInstanceId
     */
    @PostMapping("/task-handel/{processInstanceId}/task-activate")
    boolean taskActivation(@PathVariable("processInstanceId") String processInstanceId,
                           @RequestParam(value = "reason", required = false) String reason);

    /**
     * 任务锁定
     *
     * @param taskId
     */
    @PostMapping(value = "/task-handel/{taskId}/locked")
    boolean taskLock(@PathVariable("taskId") String taskId, @RequestParam("username") String username);

    /**
     * 任务解除
     *
     * @param taskId
     */
    @PostMapping(value = "/task-handel/{taskId}/unlocked")
    boolean taskUnLock(@PathVariable("taskId") String taskId);

    /**
     * 任务委托与代理
     * @param username 用户名
     * @param taskId
     */
    @PostMapping("/task-handel/{taskId}/delegation")
    boolean taskDelegation(@PathVariable("taskId") String taskId, @RequestParam("username") String username);


    /**
     * 任务认领
     * @param username
     * @return
     */
    @PostMapping("/task-handel/claim")
    boolean taskClaim(@RequestParam("username") String username, @RequestBody List<String> taskIds);

    /**
     * 任务解绑
     * @param taskId
     * @return
     */
    @PostMapping("/task-handel/unclaim")
    boolean unClaimTask(@RequestParam("taskId") String taskId);


    /**
     * @param forwardTaskDtos
     * @return
     * @description 执行转发活动任务
     */
    @PostMapping(value = "/task-handel/forward/complete")
    boolean complete(@RequestBody List<ForwardTaskDto> forwardTaskDtos);

    /**
     * @param forwardTaskDto
     * @return
     * @description 办结活动任务
     */
    @PostMapping(value = "/task-handel/forward/end")
    boolean processEnd(@RequestBody ForwardTaskDto forwardTaskDto);

    /**
     * @param backTaskDtos
     * @return
     * @description 执行退回活动任务
     */
    @PostMapping(value = "/task-handel/back/complete")
    boolean back(List<BackTaskDto> backTaskDtos);


    /**
     * @param taskIds
     * @param forwardTaskDtos
     * @return
     * @description 批量转发流程
     */
    @PostMapping(value = "/task-handel/batch-forward/complete")
    List<ProcessOptResultDto> batchComplete(@RequestParam("taskIds") String taskIds,
                                                   @RequestBody(required = false) List<ForwardTaskDto> forwardTaskDtos);


    /**
     * @param taskId
     * @return
     * @description 执行取回活动任务
     */
    @PostMapping(value = "/task-handel/fetchBack/complete/{taskId}")
    boolean fetchBack(@PathVariable(name = "taskId")String taskId);

     /* 创建阅办任务
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/task-handel/read-tasks")
    public void addReadTask(@RequestParam("taskId") String taskId,@RequestParam("nextActivityId")String nextActivityId
            ,@RequestBody List<String>userNames);

    /* 创建协办任务
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/task-handel/help-tasks")
    public void addHelpTask(@RequestParam("taskId") String taskId,@RequestParam("nextActivityId")String nextActivityId
            ,@RequestBody List<String>userNames);

    /**
     * 结束传阅任务
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/task-handel/special-task/end")
    public void endSpecialTask(@RequestParam("taskId") String taskId);

    /**
     * 阅办任务转待办任务
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/task-handel/read-change-undo")
    public void readChangeToUndoTask(@RequestParam("taskId") String taskId);

    /**
     * 获取当前节点下所有的子特殊任务
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/task-handel/special-tasks")
    public List<TaskData> queryAllSpecialTaskList(@RequestParam("taskId") String taskId);
}
