package cn.gtmap.gtc.workflow.clients.manage;

import cn.gtmap.gtc.workflow.domain.manage.ProcessTaskTreeDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient("${app.services.bpm-manage:bpm-manage}")
@RequestMapping("manage/v1")
public interface ProcessTaskTreeClient {

    /**
     * 按照树结构显示待办任务的数目
     * @param userCode 用户id
     * @param taskType 任务类型
     * @return
     */
    @GetMapping("/task-tree/todo")
    public List<ProcessTaskTreeDto> listTodoAllTaskTree(@RequestParam(value = "userCode",required = false)String userCode,
                                                        @RequestParam(value = "taskType",required = false)Integer taskType);


    /**
     * 按照树结构显示已办任务的数目
     * @param userCode
     * @param taskType 任务类型
     * @return
     */
    @GetMapping("/task-tree/completed")
    public List<ProcessTaskTreeDto> listCompletedAllTaskTree(@RequestParam(value = "userCode",required = false)String userCode,
                                                             @RequestParam(value = "taskType",required = false)Integer taskType);
}
