package cn.gtmap.gtc.workflow.clients.define.v1;


import cn.gtmap.gtc.workflow.domain.define.ProcessFormRelDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author lq
 * @date 20191008
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1/defFormRel")
public interface ProcessFormRelClient {

    @RequestMapping(
            value = {"/insert"},
            method = {RequestMethod.PUT},
            produces = {"application/json"}
    )
    int insert(@RequestBody ProcessFormRelDto processFormRelDto);

    @RequestMapping(
            value = {"/delete"},
            method = {RequestMethod.DELETE},
            produces = {"application/json"}
    )
    int delete(@RequestParam(value = "id") String id);


    @RequestMapping(
            value = {"/findByProcessDefKey"},
            method = {RequestMethod.GET},
            produces = {"application/json"}
    )
    ProcessFormRelDto findByProcessDefKey(@RequestParam(value = "processDefKey") String processDefKey);

    @RequestMapping(
            value = {"/deleteByProcessDefKey"},
            method = {RequestMethod.DELETE},
            produces = {"application/json"}
    )
    void deleteByProcessDefKey(@RequestParam(value = "processDefKey") String processDefKey);

}
