package cn.gtmap.gtc.workflow.clients.define.v1;

import cn.gtmap.gtc.workflow.domain.define.ProcessDefinedDto;
import cn.gtmap.gtc.workflow.domain.define.ProcessDefinedExtendDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhouk
 * @Title: ProcessDefineClient
 * @ProjectName workflow
 * @Description: TODO
 * @date 2018/8/1413:43
 */
@FeignClient("${app.services.bpm-define:bpm-define}")
@RequestMapping("define/v1")
public interface ProcessDefineClient {

    /**
     * 获取已发布流程定义的列表
     * @return
     */
    @RequestMapping(
            value = {"/process-defines"},
            method = {RequestMethod.GET}
    )
    public List<ProcessDefinedDto> getProcessDefineList(@RequestParam(required =false,value = "name") String name
    );


    /**
     * 获取流程的定义（已发布的模版的最新的一个）
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/page"},
            method = {RequestMethod.GET}
    )
    public Page<ProcessDefinedDto> getProcessDefines(@RequestParam(required =false,value = "name") String name,
                                             Pageable pageable);

    /**
     *获取已发布流程定义的列表（去掉绑定的流程定义，用于配置启动项的下拉选择）
     * @param
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/deplication"},
            method = {RequestMethod.GET}
    )
    public List<ProcessDefinedDto> getProcessDefineListForSelect();

    /**
     * 流程定义的历史
     * @param key
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/historys"},
            method = {RequestMethod.GET}
    )
    public Page<ProcessDefinedDto> getHistoryProcess(@RequestParam("key")String key,
                                             Pageable pageable);

    /**
     * 流程定义的锁定
     * @param processDefineId 流程定义ID
     * @param isProcessIns 是否包含实例\
     */
    @RequestMapping(
            value = {"/process-defines/suspended"},
            method = {RequestMethod.PUT}
    )
    public void suspendProcessDefinitionById(@RequestParam("processDefineId")String processDefineId ,
                                             @RequestParam("isProcessIns") boolean isProcessIns);

    /**
     * 流程定义的激活
     * @param processDefineId 流程定义ID
     * @param isProcessIns 是否包含实例
     */
    @RequestMapping(
            value = {"/process-defines/activity"},
            method = {RequestMethod.PUT}
    )
    public void activateProcessDefinitionById( @RequestParam("processDefineId")String processDefineId,
                                               @RequestParam("isProcessIns") boolean isProcessIns);


    /**
     * 流程定义的扩展
     * @param processDefinedExtendDto
     * @return
     */
    @RequestMapping(
            value = {"/process-defines/extend"},
            method = {RequestMethod.POST}
    )
    public int saveProcessDefinitionExtend(@RequestBody ProcessDefinedExtendDto processDefinedExtendDto);
}
