package cn.gtmap.gtc.workflow.clients.bpmnio;

import cn.gtmap.gtc.workflow.domain.bpmnio.GroupDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("bpmnio-define")
@RequestMapping("/rest/group")
public interface GroupClient {
    @GetMapping(value = "/findAll")
    List<GroupDto> findAll();

    @GetMapping(value = "/find/{id}")
    GroupDto findById(@PathVariable("id") String id);

    @PutMapping(value = "/add")
    GroupDto add(@RequestBody GroupDto groupDto);

    @PutMapping(value = "/addList")
    GroupDto addList(@RequestBody List<GroupDto> groupDto);

    @DeleteMapping(value = "/delList")
    void delList(@RequestBody List<GroupDto> groupDto);

    @DeleteMapping(value = "/del")
    void del(@RequestBody GroupDto groupDto);
}
